﻿using System;
using Xamarin.Forms;
using XamarinDemoApp.Services;
using Xamarin.CommunityToolkit.Extensions;

namespace XamarinDemoApp.ViewModels
{
    public class MobileMsgViewModel : BaseViewModel
    {
        public Command SmInAppMsgEventCommand { get; set; }
        public Command LgInAppMsgEventCommand { get; set; }

        public MobileMsgViewModel()
        {
            SmInAppMsgEventCommand = new Command(OnSmInAppEventClicked);
            LgInAppMsgEventCommand = new Command(OnLgInAppEventClicked);
        }

        private string smInAppMsgEventName = "smInAppMsg_Event_Xamarin_WW";
        public string SmInAppMsgEventName
        {
            get { return smInAppMsgEventName; }
            set
            {
                if (smInAppMsgEventName != value)
                {
                    smInAppMsgEventName = value;
                    OnPropertyChanged(nameof(SmInAppMsgEventName));
                }
            }
        }

        private string lgInAppMsgEventName = "lgInAppMsg_Event_Xamarin_WW";
        public string LgInAppMsgEventName
        {
            get { return lgInAppMsgEventName; }
            set
            {
                if (lgInAppMsgEventName != value)
                {
                    lgInAppMsgEventName = value;
                    OnPropertyChanged(nameof(LgInAppMsgEventName));
                }
            }
        }

        private void OnSmInAppEventClicked()
        {
            if (string.IsNullOrEmpty(smInAppMsgEventName))
            {
                Application.Current.MainPage.DisplayToastAsync("Please enter event name");
                return;
            }
            DependencyService.Get<ISDKBasicService>().AddAppEvent(smInAppMsgEventName, null);
        }

        private void OnLgInAppEventClicked()
        {
            if (string.IsNullOrEmpty(lgInAppMsgEventName))
            {
                Application.Current.MainPage.DisplayToastAsync("Please enter event name");
                return;
            }
            DependencyService.Get<ISDKBasicService>().AddAppEvent(lgInAppMsgEventName, null);
        }

    }
}

