﻿using System;
using Xamarin.Forms;
using XamarinDemoApp.Services;
using System.ComponentModel;
using System.Runtime.CompilerServices;


namespace XamarinDemoApp.ViewModels
{
    public partial class LoginViewModel : BaseViewModel
    {

        public Command LoginCommand { get; set; }

        public LoginViewModel()
        {
            LoginCommand = new Command(OnLoginClicked);
        }

        
        string identityType;
        public string IdentityType
        {
            get { return identityType; }
            set
            {
                if (identityType != value)
                {
                    identityType = value;
                    OnPropertyChanged(nameof(IdentityType));
                }
            }
        }

        
        string identityValue;
        public string IdentityValue
        {
            get { return identityValue; }
            set
            {
                if (identityValue != value)
                {
                    identityValue = value;
                    OnPropertyChanged(nameof(IdentityValue));
                }
            }
        }
        

        private async void OnLoginClicked(object obj)
        {
            await DependencyService.Get<ISDKBasicService>().Identity(identityType, identityValue);
        }
    }
}

