﻿using System;
using System.Collections.Generic;
using Xamarin.Forms;
using XamarinDemoApp.Services;
using Xamarin.CommunityToolkit.Extensions;

namespace XamarinDemoApp.ViewModels
{
	public class HomeViewModel : BaseViewModel
	{
		public Command NewPageCommand { get; set; }
		public Command AddAppEventCommand { get; set; }
		public Command GetDeviceIdCommand { get; set; }
		public Command GetTagServerCommand { get; set; }


        public HomeViewModel()
		{
			NewPageCommand = new Command(OnNewPageClicked);
			AddAppEventCommand = new Command(OnAddAppEventClicked);
			GetDeviceIdCommand = new Command(OnGetDeviceIdClicked);
			GetTagServerCommand = new Command(OnGetTagServerClicked);
		}

		private string newPageUrl;
		public string NewPageUrl
		{
			get { return newPageUrl; }
			set
			{
				if (newPageUrl != value)
				{
					newPageUrl = value;
					OnPropertyChanged(nameof(newPageUrl));
				}
			}
		}

		private string eventName;
		public string EventName
		{
			get { return eventName; }
			set
			{
				if (eventName != value)
				{
					eventName = value;
					OnPropertyChanged(nameof(eventName));
				}
			}
		}

		private string eventAttrKey;
		public string EventAttrKey
		{
			get { return eventAttrKey; }
			set
			{
				if (eventAttrKey != value)
				{
					eventAttrKey = value;
					OnPropertyChanged(nameof(EventAttrKey));
				}
			}
		}

        private string eventAttrValue;
        public string EventAttrValue
        {
            get { return eventAttrValue; }
            set
            {
                if (eventAttrValue != value)
                {
                    eventAttrValue = value;
                    OnPropertyChanged(nameof(EventAttrValue));
                }
            }
        }

		private string deviceId;
		public string DeviceId
		{
			get { return deviceId; }
			set
			{
				if (deviceId != value)
				{
					deviceId = value;
					OnPropertyChanged(nameof(DeviceId));
				}
			}
		}

		private string tagServer;
		public string TagServer
		{
			get { return tagServer; }
			set
			{
				if (tagServer != value)
				{
					tagServer = value;
					OnPropertyChanged(nameof(TagServer));
				}
			}
		}

        private async void OnNewPageClicked()
		{
			DependencyService.Get<ISDKBasicService>().NewPage(NewPageUrl);
			await Application.Current.MainPage.DisplayToastAsync("New Page event is sent");
		}

		private void OnAddAppEventClicked()
		{
			if (string.IsNullOrEmpty(eventName))
			{
				return;
			}

			Dictionary<string, string> eventAttributes = null;
			if (!string.IsNullOrEmpty(eventAttrKey) && !string.IsNullOrEmpty(eventAttrValue))
			{
				eventAttributes = new Dictionary<string, string>()
				{
					{eventAttrKey, eventAttrValue }
				};
			}
			DependencyService.Get<ISDKBasicService>().AddAppEvent(eventName, eventAttributes);
		}

		private void OnGetDeviceIdClicked()
		{
            DeviceId =  DependencyService.Get<ISDKBasicService>().GetDeviceId();
		}

		private void OnGetTagServerClicked()
		{
			TagServer = DependencyService.Get<ISDKBasicService>().GetTagServer();
		}
	}
}

