﻿using System;
using System.Collections.Generic;
using System.Web;
using Xamarin.Forms;
using XamarinDemoApp.Services;

namespace XamarinDemoApp.ViewModels
{
	public class DetailsViewModel : BaseViewModel, IQueryAttributable
	{
        public Command DetachIdentityCommand { get; }

        public DetailsViewModel()
		{
            DetachIdentityCommand = new Command(OnDetachIdentityClicked);
		}

        private string loginId;
        public string LoginId
        {
            get { return loginId; }
            set {
                if (loginId != value)
                {
                    loginId = value;
                    OnPropertyChanged(nameof(LoginId));
                }
            }
        }

        private async void OnDetachIdentityClicked()
        {
            await DependencyService.Get<ISDKBasicService>().DetachIdentity();
        }


        public void ApplyQueryAttributes(IDictionary<string, string> query)
        {
            LoginId = HttpUtility.UrlDecode(query["loginId"]);
        }
    }
}

