﻿using System;
using Xamarin.CommunityToolkit.Extensions;
using Xamarin.Forms;
using XamarinDemoApp.Views;


namespace XamarinDemoApp.Services
{
    public class MobileMessageHandler
    {
        public static async void OnMsgDismissed()
        {
            await Application.Current.MainPage.DisplayToastAsync("Mobile Message is dismissed.");
        }

        public static async void OnMsgLinkClicked(string url, Boolean isPushNotification)
        {
            if (String.IsNullOrEmpty(url)) {
                return;
            }
            string msg = isPushNotification ? "Push notification link: " : "In-App Message link: ";
            await Application.Current.MainPage.DisplayToastAsync(msg + url + " is clicked");
            if (url.Equals("app://diagnostics")) {    
                Shell.Current.CurrentItem = Shell.Current.Items[0].Items[4];
            }
        }
    }
}

