﻿using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Xamarin.Forms;
using XamarinDemoApp.iOS.Services;
using XamarinDemoApp.Services;
using Foundation;
using Com.SAS.CI360;
using XamarinDemoApp.Views;
using Xamarin.Essentials;

[assembly: Xamarin.Forms.Dependency(typeof(SDKBasicService))]
namespace XamarinDemoApp.iOS.Services
{
	public class SDKBasicService : ISDKBasicService
	{
        public async Task Identity(string type, string value)
        {
            Action<bool> completionHandler = (bool isSuccess) =>
            {
                MainThread.InvokeOnMainThreadAsync(() =>
                {
                    if (isSuccess)
                    {
                        (App.Current as XamarinDemoApp.App).GoToDetails(value);
                    }
                    else
                    {
                        (App.Current as XamarinDemoApp.App).DisplayToastMsg("Login Failed");
                    }
                });
            };
            await Task.Run(() => SASCollector.Identity(value, type, completionHandler));
        }

        public async Task DetachIdentity()
        {
            Action<bool> completionHandler = (bool isSuccess) =>
            {
                MainThread.InvokeOnMainThreadAsync(() =>
                {
                    if (isSuccess)
                    {
                        ((XamarinDemoApp.App)App.Current).GoToLogin();
                    }
                    else
                    {
                        (App.Current as XamarinDemoApp.App).DisplayToastMsg("Logout failed");
                    }
                });
            };
            await Task.Run(() => SASCollector.DetachIdentity(completionHandler));
        }

        public void NewPage(string url)
        {
            SASCollector.NewPage(url);
        }

        public void AddAppEvent(string eventName, Dictionary<string, string> attrs)
        {
            NSMutableDictionary<NSString, NSString> eventAttrs = new NSMutableDictionary<NSString, NSString>();

            if (attrs == null)
            {
                SASCollector.AddAppEvent(eventName, null);
                return;
            }
            foreach(var attr in attrs)
            {
                NSString key = NSString.FromData(attr.Key, NSStringEncoding.UTF8);
                NSString value = NSString.FromData(attr.Value, NSStringEncoding.UTF8);
                eventAttrs.Add(key, value);
            }
            SASCollector.AddAppEvent(eventName, eventAttrs);
        }

        

        public void StartMonitoringLocation()
        {
            SASCollector.StartMonitoringLocation();
        }

        public void DisableLocationMonitoring()
        {
            SASCollector.DisableLocationMonitoring();
        }

        public string GetDeviceId()
        {
            return SASCollector.DeviceId;
        }

        public void ResetDeviceId()
        {
            SASCollector.ResetDeviceId();
        }

        public string GetTagServer()
        {
            return SASCollector.TagServer;
        }

        public void SetTagServer(string newServer)
        {
            SASCollector.TagServer = newServer;
        }

        public string GetTenantId()
        {
            return SASCollector.TenantId;
        }

        public void SetTenantId(string newTenant)
        {
            SASCollector.TenantId = newTenant;
        }
    }
}

