﻿using System;
using Xamarin.Forms;
using Xamarin.Forms.Platform.iOS;
using UIKit;
using XamarinDemoApp.SDKMobileSpots;
using XamarinDemoApp.iOS.SDKMobileSpots;
using Com.SAS.CI360;
using Foundation;
using System.Diagnostics;
using System.Linq;
using Xamarin.Forms.PlatformConfiguration;
using CoreGraphics;

[assembly: ExportRenderer(typeof(InterstitialAdView), typeof(InterstitialAdViewRenderer))]
namespace XamarinDemoApp.iOS.SDKMobileSpots
{
	public class InterstitialAdViewRenderer : ViewRenderer
	{
        SASCollectorInterstitialAd adView;

        protected override void OnElementChanged(ElementChangedEventArgs<View> e)
        {
            base.OnElementChanged(e);
            if (Control == null)
            {
                try
                {
                    adView = new SASCollectorInterstitialAd();
                    
                    adView.Delegate = new InterstitialAdDelegate();
                   
                    adView.SpotID = (Element as InterstitialAdView).SpotId;
                    adView.Load();
                    
                } catch(Exception err)
                {
                    Debug.WriteLine(err.ToString());
                }
            }

        }
    }

    public class InterstitialAdDelegate : SASIA_AdDelegate
    {
        public override void DidLoad(SASIA_AbstractAd ad)
        {
            
            (ad as SASCollectorInterstitialAd).ShowFromController(GetTopViewController());
            InterstitialAdDelegateHandler.OnAdLoaded();

        }

        

        public override void DidFailLoad(SASIA_AbstractAd ad, NSError error, string failingUrl)
        {
            InterstitialAdDelegateHandler.OnAdLoadFailed();
        }

        public override void DidLoadDefault(SASIA_AbstractAd ad)
        {
            InterstitialAdDelegateHandler.OnAdDefaultLoaded();
        }

        public override void DidFinishAction(SASIA_AbstractAd ad)
        {
            InterstitialAdDelegateHandler.OnAdDefaultLoaded();
        }

        public override bool WillExpand(SASIA_AbstractAd ad, string url)
        {
            return InterstitialAdDelegateHandler.OnAdWillExpand();
        }

        public override void DidFinishExpand(SASIA_AbstractAd ad)
        {
            InterstitialAdDelegateHandler.OnAdExpandFinished();
        }

        public override bool WillResize(SASIA_AbstractAd ad, CGRect size)
        {
            return InterstitialAdDelegateHandler.OnAdWillResize();
        }

        public override void DidFinishResize(SASIA_AbstractAd ad)
        {
            InterstitialAdDelegateHandler.OnAdResizeFinished();
        }

        public override void DidClose(SASIA_AbstractAd ad)
        {
            InterstitialAdDelegateHandler.OnAdClosed();
        }





        private static UIViewController GetTopViewController()
        {
            var window = UIApplication.SharedApplication.KeyWindow;
            var vc = window.RootViewController;
            while (vc.PresentedViewController != null)
                vc = vc.PresentedViewController;

            if (vc is UINavigationController navController)
                vc = navController.ViewControllers.Last();

            return vc;
        }
    }
}

