﻿using System;
using Xamarin.Forms;
using Xamarin.Forms.Platform.iOS;
using XamarinDemoApp.SDKMobileSpots;
using XamarinDemoApp.iOS.SDKMobileSpots;
using Com.SAS.CI360;
using Foundation;
using CoreGraphics;

[assembly:ExportRenderer(typeof(InlineAdView), typeof(InlineAdViewRenderer))]
namespace XamarinDemoApp.iOS.SDKMobileSpots
{
    public class InlineAdViewRenderer : ViewRenderer
    {
        SASCollectorUIAdView adView;

        protected override void OnElementChanged(ElementChangedEventArgs<View> e)
        {
            base.OnElementChanged(e);
            if (Control == null)
            {
                adView = new SASCollectorUIAdView();
                adView.Delegate = new InlineAdViewDelegate();
             
                SetNativeControl(adView);
                adView.SpotID = (Element as InlineAdView).SpotId;
                adView.Load();
            }
        }
    }

    public class InlineAdViewDelegate : SASIA_AdDelegate
    {
        public override void DidLoad(SASIA_AbstractAd ad)
        {
            InlineAdDelegateHandler.OnAdLoaded();
        }

        public override void DidLoadDefault(SASIA_AbstractAd ad)
        {
            InlineAdDelegateHandler.OnAdDefaultLoaded();
        }

        public override void DidFailLoad(SASIA_AbstractAd ad, NSError error, string failingUrl)
        {
            InlineAdDelegateHandler.OnAdLoadFailed();
        }

        public override void DidFinishAction(SASIA_AbstractAd ad)
        {
            InlineAdDelegateHandler.OnAdActionFinished();
        }

        public override bool WillExpand(SASIA_AbstractAd ad, string url)
        {
            return InlineAdDelegateHandler.OnAdWillExpand();
        }

        public override void DidFinishExpand(SASIA_AbstractAd ad)
        {
            InlineAdDelegateHandler.OnAdExpandFinished();
        }

        public override bool WillResize(SASIA_AbstractAd ad, CGRect size)
        {
            return InlineAdDelegateHandler.OnAdWillExpand();
        }

        public override void DidFinishResize(SASIA_AbstractAd ad)
        {
            InlineAdDelegateHandler.OnAdResizeFinished();
        }

        public override void DidClose(SASIA_AbstractAd ad)
        {
            InlineAdDelegateHandler.OnAdClosed();
        }
    }
}

