﻿using System;
using Android.App;
using Firebase.Messaging;
using Com.Sas.Mkt.Mobile.Sdk;

namespace XamarinDemoApp.Droid.Services
{
	[Service (Exported = false)]
	[IntentFilter(new[] {"com.google.firebase.MESSAGING_EVENT"})]
	public class XamarinFirebaseMessagingService : FirebaseMessagingService
	{
        public override void OnMessageReceived(RemoteMessage message)
        {
            base.OnMessageReceived(message);
			if (!SASCollector.Instance.HandleMobileMessage(message.Data))
			{
				// Handle non-SASCollector message
			}
        }

        public override void OnNewToken(string token)
        {
            base.OnNewToken(token);
			if (token != null)
			{
				SASCollector.Instance.RegisterForMobileMessages(token);
			}
        }
    }
}

