﻿using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using XamarinDemoApp.Droid.Services;
using XamarinDemoApp.Services;
using Com.Sas.Mkt.Mobile.Sdk;
using Xamarin.Essentials;
using XamarinDemoApp.Views;

[assembly: Xamarin.Forms.Dependency(typeof(SDKBasicService))]
namespace XamarinDemoApp.Droid.Services
{
	public class SDKBasicService : ISDKBasicService
    {
        public void AddAppEvent(string eventName, Dictionary<string, string> attrs)
        {
            SASCollector.Instance.AddAppEvent(eventName, attrs);
        }

        public void NewPage(string url)
        {
            SASCollector.Instance.NewPage(url);
        }

        public async Task Identity(string type, string value)
        {
            await Task.Run(() => SASCollector.Instance.Identity(value, type, new IdentityCallback(value)));
        }

        public async Task DetachIdentity()
        {
            await Task.Run(() => SASCollector.Instance.DetachIdentity(new DetachIdentityCallback()));
        }

        public void StartMonitoringLocation()
        {
            SASCollector.Instance.StartMonitoringLocation();
        }

        public void DisableLocationMonitoring()
        {
            SASCollector.Instance.DisableLocationMonitoring();
        }

        public string GetDeviceId()
        {
            return SASCollector.Instance.DeviceID;
        }

        public void ResetDeviceId()
        {
            SASCollector.Instance.ResetDeviceID();
        }
        
        public string GetTagServer()
        {
            return SASCollector.Instance.TagServer;
        }

        public void SetTagServer(string newServer)
        {
            SASCollector.Instance.TagServer = newServer;
        }

        public string GetTenantId()
        {
            return SASCollector.Instance.TenantID;
        }

        public void SetTenantId(string newTenant)
        {
            SASCollector.Instance.TenantID = newTenant;
        }
        
    }



    public class IdentityCallback : Java.Lang.Object, SASCollector.IIdentityCallback
    {
        private string loginId;

        public IdentityCallback(string loginId)
        {
            this.loginId = loginId;
        }

        public void OnComplete(bool isSuccess)
        {
            MainThread.InvokeOnMainThreadAsync(() =>
            {
                if (isSuccess)
                {
                    (App.Current as XamarinDemoApp.App).GoToDetails(loginId);
                }
                else
                {
                    (App.Current as XamarinDemoApp.App).DisplayToastMsg("Login failed");
                }
            });
        }
    }

    public class DetachIdentityCallback : Java.Lang.Object, SASCollector.IDetachIdentityCallback
    {
        public void OnComplete(bool isSuccess)
        {
            MainThread.InvokeOnMainThreadAsync(() =>
            {
                if (isSuccess)
                {
                    (App.Current as XamarinDemoApp.App).GoToLogin();
                }
                else
                {
                    (App.Current as XamarinDemoApp.App).DisplayToastMsg("Logout failed");
                }
            });
        }
    }
}

