﻿using System;
using Android.Content;
using Xamarin.Forms;
using Xamarin.Forms.Platform.Android;
using XamarinDemoApp.Droid.SDKMobileSpots;
using XamarinDemoApp.SDKMobileSpots;
using Com.Sas.Mkt.Mobile.Sdk.Ads;
using Com.Sas.IA.Android.Sdk;

[assembly:ExportRenderer(typeof(InterstitialAdView),typeof(InterstitialAdViewRenderer))]
namespace XamarinDemoApp.Droid.SDKMobileSpots
{
	public class InterstitialAdViewRenderer : ViewRenderer
	{
        SASCollectorInterstitialAd adView;

		public InterstitialAdViewRenderer(Context context) : base(context)
		{
		}

        protected override void OnElementChanged(ElementChangedEventArgs<View> e)
        {
            base.OnElementChanged(e);
            if (Control == null)
            {
                adView = new SASCollectorInterstitialAd(Context);
                adView.Delegate = new InterstitialAdViewDelegate();
                SetNativeControl(adView);
                string spotId = (Element as InterstitialAdView).SpotId;
                adView.Load(spotId, null);
            }
        }

    }

    public class InterstitialAdViewDelegate : AdDelegate
    {
        public override void OnLoaded(AbstractAd ad)
        {
            (ad as SASCollectorInterstitialAd)?.Show();
            InterstitialAdDelegateHandler.OnAdLoaded();
            
        }

        public override void OnLoadFailed(AbstractAd ad, int errorCode, string description, string failingUrl)
        {
            InterstitialAdDelegateHandler.OnAdLoadFailed();
        }

        public override void OnDefaultLoaded(AbstractAd ad)
        {
            InterstitialAdDelegateHandler.OnAdDefaultLoaded();

        }

        public override void OnActionFinished(AbstractAd ad)
        {
            InterstitialAdDelegateHandler.OnAdActionFinished();
        }

        public override bool WillExpand(AbstractAd ad, string url)
        {
            return InterstitialAdDelegateHandler.OnAdWillExpand();
        }

        public override void OnExpandFinished(AbstractAd ad)
        {
            InterstitialAdDelegateHandler.OnAdExpandFinished();
        }

        public override bool WillResize(AbstractAd ad, Android.Graphics.Rect size)
        {
            return InterstitialAdDelegateHandler.OnAdWillResize();
        }

        public override void OnResizeFinished(AbstractAd ad)
        {
            InterstitialAdDelegateHandler.OnAdResizeFinished();
        }

        public override void OnClosed(AbstractAd ad)
        {
            InterstitialAdDelegateHandler.OnAdClosed();
        }
    }
}

