﻿
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.OS;
using Android.Runtime;
using Android.Util;
using Android.Views;
using Android.Widget;
using Com.Sas.IA.Android.Sdk;
using Com.Sas.Mkt.Mobile.Sdk.Ads;
using Xamarin.Forms;
using Xamarin.Forms.Platform.Android;
using XamarinDemoApp.SDKMobileSpots;
using XamarinDemoApp.Droid.SDKMobileSpots;

[assembly:ExportRenderer(typeof(InlineAdView), typeof(InlineAdViewRenderer))]
namespace XamarinDemoApp.Droid.SDKMobileSpots
{
    public class InlineAdViewRenderer : ViewRenderer
    {
        SASCollectorAd adView;

        public InlineAdViewRenderer(Context context) :
            base(context)
        {
        }

        protected override void OnElementChanged(ElementChangedEventArgs<Xamarin.Forms.View> e)
        {
            base.OnElementChanged(e);
            if (Control == null)
            {
                adView = new SASCollectorAd(Context);
                adView.Delegate = new InlineAdViewDelegate();

                this.SetNativeControl(adView);
                InlineAdView v = Element as InlineAdView;
                adView.Load(v.SpotId, null);
            }
        }

    }

    public class InlineAdViewDelegate : AdDelegate
    {
        public override void OnLoaded(AbstractAd ad)
        {

            InlineAdDelegateHandler.OnAdLoaded();
        }

        public override void OnDefaultLoaded(AbstractAd ad)
        {
            InlineAdDelegateHandler.OnAdDefaultLoaded();
        }


        public override void OnLoadFailed(AbstractAd ad, int errorCode, string description, string failingUrl)
        {
            InlineAdDelegateHandler.OnAdLoadFailed();
        }

        public override void OnActionFinished(AbstractAd ad)
        {
            InlineAdDelegateHandler.OnAdActionFinished();
        }

        public override bool WillExpand(AbstractAd ad, string url)
        {
            return InlineAdDelegateHandler.OnAdWillExpand();
        }

        public override void OnExpandFinished(AbstractAd ad)
        {
            InlineAdDelegateHandler.OnAdExpandFinished();
        }

        public override bool WillResize(AbstractAd ad, Android.Graphics.Rect size)
        {
            return InlineAdDelegateHandler.OnAdWillResize();
        }

        public override void OnResizeFinished(AbstractAd ad)
        {
            InlineAdDelegateHandler.OnAdResizeFinished();
        }

        public override void OnClosed(AbstractAd ad)
        {
            InlineAdDelegateHandler.OnAdClosed();
        }

 
    }
}

