﻿using System;

using Android.App;
using Android.Content.PM;
using Android.Runtime;
using Android.OS;
using Android.Gms.Tasks;
using Firebase.Messaging;
using Com.Sas.Mkt.Mobile.Sdk;
using Com.Sas.Mkt.Mobile.Sdk.Iam;
using Com.Sas.Mkt.Mobile.Sdk.Util;
using Android.Content;
using Firebase;
using XamarinDemoApp.Services;

namespace XamarinDemoApp.Droid
{
    [Activity(Label = "XamarinDemoApp", Icon = "@mipmap/icon", Theme = "@style/MainTheme", MainLauncher = true, LaunchMode = LaunchMode.SingleInstance, ConfigurationChanges = ConfigChanges.ScreenSize | ConfigChanges.Orientation | ConfigChanges.UiMode | ConfigChanges.ScreenLayout | ConfigChanges.SmallestScreenSize )]
    public class MainActivity : global::Xamarin.Forms.Platform.Android.FormsAppCompatActivity
    {
        protected override void OnCreate(Bundle savedInstanceState)
        {
            base.OnCreate(savedInstanceState);

            Xamarin.Essentials.Platform.Init(this, savedInstanceState);
            global::Xamarin.Forms.Forms.Init(this, savedInstanceState);
            LoadApplication(new App());
            SLog.Level = SLog.All;
            SASCollector.Instance.Initialize(ApplicationContext);
            

            FirebaseApp.InitializeApp(this);
            FirebaseMessaging.Instance?.GetToken()
                .AddOnSuccessListener(this, new FirebaseOnSuccessListener())
                .AddOnFailureListener(this, new FirebaseOnFailureListener());

            SetPushChannel();
            SetMobileMessageDelegate();

            String notificationLink = Intent.GetStringExtra("notificationLink");
            MobileMessageHandler.OnMsgLinkClicked(notificationLink, true);

        }

        protected override void OnNewIntent(Intent intent)
        {
            base.OnNewIntent(intent);

            Bundle bundle = intent.Extras;
            this.Intent.PutExtras(bundle);

            String notificationLink = intent.GetStringExtra("notificationLink");
            MobileMessageHandler.OnMsgLinkClicked(notificationLink, true);
        }

        public override void OnRequestPermissionsResult(int requestCode, string[] permissions, [GeneratedEnum] Android.Content.PM.Permission[] grantResults)
        {
            Xamarin.Essentials.Platform.OnRequestPermissionsResult(requestCode, permissions, grantResults);

            base.OnRequestPermissionsResult(requestCode, permissions, grantResults);
        }

        private void SetPushChannel()
        {

            string channelId = "XamarinPushChannel1";
            string channelName = "Xamarin Push Channel1";
            NotificationManager notificationManager = (NotificationManager)GetSystemService(NotificationService);
            NotificationChannel channel = new NotificationChannel(channelId, channelName, NotificationImportance.High);
            channel.EnableLights(true);     
            channel.EnableVibration(true);
            channel.SetShowBadge(true);
            
            
            notificationManager.CreateNotificationChannel(channel);
            SASCollector.Instance.SetPushNotificationChannelId(channelId);
            SASCollector.Instance.SetMobileMessagingIcon(Resource.Drawable.spotlight);
        }

        
        private void SetMobileMessageDelegate()
        {
            SASCollector.Instance.MobileMessagingDelegate2 = new MobileMessageDelegate2(this);
        }
    }

    public class FirebaseOnSuccessListener : Java.Lang.Object, IOnSuccessListener
    {

        public void OnSuccess(Java.Lang.Object result)
        {
            string token = result.ToString();
            SASCollector.Instance.RegisterForMobileMessages(token);

        }
    }

    public class FirebaseOnFailureListener : Java.Lang.Object, IOnFailureListener
    {
        public void OnFailure(Java.Lang.Exception e)
        {
            Console.WriteLine(e.LocalizedMessage);
        }
    }

    public class MobileMessageDelegate2 : Java.Lang.Object, ISASMobileMessagingDelegate2
    {
        private Context context;

        public MobileMessageDelegate2(Context context)
        {
            this.context = context;
        }

        public void Action(string link, SASMobileMessagingDelegate2SASMobileMessageType msgType)
        {
            Console.WriteLine("Mobile message is clicked");
            MobileMessageHandler.OnMsgLinkClicked(link, false);
        }

        public void Dismissed()
        {
            Console.WriteLine("Mobile message is dismissed");
            MobileMessageHandler.OnMsgDismissed();
        }

        public Intent GetNotificationIntent(string s)
        {
            Intent intent = new Intent(context as Activity, typeof(MainActivity));
            intent.PutExtra("notificationLink", s);
            return intent;
        }
    }
}
