﻿using System;
using System.Runtime.InteropServices;
using Foundation;
using ObjCRuntime;

namespace Com.SAS.CI360
{
    //[Flags]
    [Native]
    public enum SASLoggerFlag : ulong
    {
        Error = (1uL << 0),
        Warning = (1uL << 1),
        Info = (1uL << 2),
        Debug = (1uL << 3),
        Verbose = (1uL << 4)
    }

    [Native]
    public enum SASLoggerLevel : ulong
    {
        Off = 0,
        Error = (SASLoggerFlag.Error),
        Warning = (Error | SASLoggerFlag.Warning),
        Info = (Warning | SASLoggerFlag.Info),
        Debug = (Info | SASLoggerFlag.Debug),
        Verbose = (Debug | SASLoggerFlag.Verbose),
        All = 18446744073709551615
        //All = (9223372036854775807L * 2 + 1)
    }

    static class CFunctions
    {
        // extern NSString * SASLoggerExtractFileNameWithoutExtension (const char *filePath, BOOL copy);
        [DllImport("__Internal")]
        // [Verify (PlatformInvoke)]
        static extern unsafe NSString SASLoggerExtractFileNameWithoutExtension(string filePath, bool copy);
    }

    [Native]
    public enum SASMobileMessageType : long
    {
        InAppMessage,
        PushNotification
    }
}




