/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class SecureStorage {
    public static final String TAG = SecureStorage.class.getSimpleName();
    private SecretKey encryptKey;
    private String encryptSalt = "HNbDhtT9gCoFkxsK94rD";
    private static SecureStorage instance;

    public static SecureStorage getInstance() {
        if (instance == null) {
            instance = new SecureStorage();
        }
        return instance;
    }

    private SecureStorage() {
    }

    public void init(String tenantId) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            PBEKeySpec spec = new PBEKeySpec(tenantId.toCharArray(), this.encryptSalt.getBytes(), 65536, 256);
            this.encryptKey = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
        }
        catch (Exception e) {
            SLog.e(TAG, (CharSequence)("Error initializing encryption: " + e.getMessage()), e);
        }
    }

    public void writeSimple(Context context, String key, String value) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.sas.mkt.mobile.sdk.SASCollector", 0);
        String encrypted = this.encrypt(value);
        if (encrypted == null) {
            SLog.e(TAG, (CharSequence)"Unable to encrypt content.", new Object[0]);
            return;
        }
        sharedPreferences.edit().putString(key, encrypted).apply();
    }

    public void removeSimple(Context context, String key) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.sas.mkt.mobile.sdk.SASCollector", 0);
        if (sharedPreferences.contains(key)) {
            sharedPreferences.edit().remove(key).apply();
        }
    }

    private String encrypt(String content) {
        try {
            if (content == null) {
                return null;
            }
            byte[] iv = this.generateIv();
            Cipher cipher = this.getCipher(1, iv);
            byte[] encrypted = cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
            byte[] final_content = new byte[iv.length + encrypted.length];
            System.arraycopy(iv, 0, final_content, 0, iv.length);
            System.arraycopy(encrypted, 0, final_content, iv.length, encrypted.length);
            String encoded = Base64.encodeToString((byte[])final_content, (int)0);
            return encoded;
        }
        catch (Exception e) {
            SLog.e(TAG, (CharSequence)("Error writing to encryption: " + e.getMessage()), e);
            return null;
        }
    }

    private Cipher getCipher(int mode, byte[] iv) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(mode, (Key)this.encryptKey, new IvParameterSpec(iv));
        return cipher;
    }

    private byte[] generateIv() {
        byte[] iv = new byte[16];
        new SecureRandom().nextBytes(iv);
        return iv;
    }

    private String decrypt(String encryptedContent, String defaultValue) {
        try {
            if (encryptedContent == null) {
                return defaultValue;
            }
            byte[] encrypted_bytes = Base64.decode((String)encryptedContent, (int)0);
            byte[] iv = new byte[16];
            System.arraycopy(encrypted_bytes, 0, iv, 0, 16);
            Cipher cipher = this.getCipher(2, iv);
            byte[] unencrypted = cipher.doFinal(encrypted_bytes, iv.length, encrypted_bytes.length - iv.length);
            return new String(unencrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            SLog.e(TAG, (CharSequence)("Error reading from encryption: " + e.getMessage()), e);
            return defaultValue;
        }
    }

    public String readSimple(Context context, String key, String defaultValue) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.sas.mkt.mobile.sdk.SASCollector", 0);
        String encryptedContent = sharedPreferences.getString(key, null);
        if (encryptedContent == null) {
            return defaultValue;
        }
        return this.decrypt(encryptedContent, defaultValue);
    }
}

