/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.util;

import android.util.Log;

public class SLog {
    private static final String BASETAG = "SASCollector::";
    public static final String TAG_API = "SASCOLLECTOR_API";
    public static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int WARN = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    public static final int VERBOSE = 5;
    public static final int ALL = 6;
    private static int level = 1;

    public static void setLevel(int newLevel) {
        level = newLevel;
    }

    public static int getLevel() {
        return level;
    }

    public static void dapi(String name, Object ... args) {
        if (args.length > 0) {
            StringBuffer buffer = new StringBuffer("(DEPRECATED) %s");
            for (Object arg : args) {
                buffer.append(" %s");
            }
            SLog.w(TAG_API, buffer.toString(), name, args);
        } else {
            SLog.w(TAG_API, "(DEPRECATED) %s", name);
        }
    }

    public static void api(String name, Object ... args) {
        if (level >= 3) {
            if (args.length > 0) {
                StringBuffer buffer = new StringBuffer();
                for (Object arg : args) {
                    buffer.append(" %s");
                }
                String params = SLog.format(buffer.toString(), args);
                SLog.i(TAG_API, "%s: [%s]", name, params);
            } else {
                SLog.i(TAG_API, "%s", name);
            }
        }
    }

    public static void d(String tag, CharSequence format, Object ... args) {
        if (level >= 4) {
            Log.d((String)(BASETAG + tag), (String)SLog.format(format, args));
        }
    }

    public static void fullException(String tag, String context, Throwable t) {
        if (level >= 4) {
            Log.e((String)tag, (String)context, (Throwable)t);
        }
    }

    public static void v(String tag, CharSequence format, Object ... args) {
        if (level >= 5) {
            Log.v((String)(BASETAG + tag), (String)SLog.format(format, args));
        }
    }

    public static void i(String tag, CharSequence format, Object ... args) {
        if (level >= 3) {
            Log.i((String)(BASETAG + tag), (String)SLog.format(format, args));
        }
    }

    public static void w(String tag, CharSequence format, Object ... args) {
        if (level >= 2) {
            Log.w((String)(BASETAG + tag), (String)SLog.format(format, args));
        }
    }

    public static void e(String tag, CharSequence format, Object ... args) {
        if (level >= 1) {
            Log.e((String)(BASETAG + tag), (String)SLog.format(format, args));
        }
    }

    public static void e(Throwable t, String tag, CharSequence format, Object ... args) {
        if (level >= 1) {
            Log.e((String)(BASETAG + tag), (String)SLog.format(format, args), (Throwable)t);
        }
    }

    private static String format(CharSequence format, Object ... args) {
        if (args != null && args.length > 0) {
            try {
                return String.format(format.toString(), args);
            }
            catch (Exception e) {
                return "(format error) " + format + " args.length=" + (args == null ? "null" : Integer.valueOf(args.length));
            }
        }
        return format.toString();
    }
}

