/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class ImageHandler {
    private static final String TAG = ImageHandler.class.getSimpleName();

    public static int pixelsToDip(Context context, int pixels) {
        int dip = (int)(context.getResources().getDisplayMetrics().density * (float)pixels + 0.5f);
        return dip;
    }

    public static Bitmap loadAndScaleImage(Context context, String filename, int requiredWidth, int requiredHeight) {
        if (filename == null) {
            SLog.e(TAG, (CharSequence)"Null filename.", new Object[0]);
            return null;
        }
        try {
            float density = context.getResources().getDisplayMetrics().density;
            requiredWidth = (int)((float)requiredWidth * density);
            requiredHeight = (int)((float)requiredHeight * density);
            SLog.d(TAG, "Device density is %f, target size %d x %d", Float.valueOf(density), requiredWidth, requiredHeight);
            File file = new File(filename);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)new FileInputStream(file), null, (BitmapFactory.Options)options);
            int actual_height = options.outHeight;
            int actual_width = options.outWidth;
            SLog.d(TAG, "Image is %d x %d", actual_width, actual_height);
            options.inJustDecodeBounds = false;
            options.inSampleSize = ImageHandler.calculateInSampleSize(options, requiredWidth, requiredHeight);
            SLog.d(TAG, "Sampling at %d", options.inSampleSize);
            Bitmap bmp = BitmapFactory.decodeStream((InputStream)new FileInputStream(file), null, (BitmapFactory.Options)options);
            if (bmp != null) {
                return bmp;
            }
            SLog.e(TAG, (CharSequence)("Unable to decode graphic file: " + filename), new Object[0]);
            return null;
        }
        catch (Exception e) {
            SLog.e(e, TAG, "Error reading image file: " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize >= reqHeight && halfWidth / inSampleSize >= reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }
}

