/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.util;

import android.content.Context;
import android.graphics.Matrix;
import android.util.AttributeSet;
import android.widget.ImageView;

public class CropImageView
extends ImageView {
    float mWidthPercent = 0.0f;
    float mHeightPercent = 0.0f;

    public CropImageView(Context context) {
        super(context);
        this.setup();
    }

    public CropImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup();
    }

    public CropImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setup();
    }

    private void setup() {
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.recomputeImgMatrix();
    }

    protected boolean setFrame(int l, int t, int r, int b) {
        this.recomputeImgMatrix();
        return super.setFrame(l, t, r, b);
    }

    private void recomputeImgMatrix() {
        int drawableHeight;
        if (this.getDrawable() == null) {
            return;
        }
        Matrix matrix = this.getImageMatrix();
        int viewWidth = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int viewHeight = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int drawableWidth = this.getDrawable().getIntrinsicWidth();
        float scale = drawableWidth * viewHeight > (drawableHeight = this.getDrawable().getIntrinsicHeight()) * viewWidth ? (float)viewHeight / (float)drawableHeight : (float)viewWidth / (float)drawableWidth;
        matrix.setScale(scale, scale);
        this.setImageMatrix(matrix);
    }
}

