/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.tasks;

import com.sas.mkt.mobile.sdk.InternalSingleton;
import com.sas.mkt.mobile.sdk.tasks.BaseSASCollectorTask;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;

public class SASCollectorExecutor
extends ScheduledThreadPoolExecutor
implements RejectedExecutionHandler {
    private final String TAG = SASCollectorExecutor.class.getSimpleName();
    private Queue<Runnable> deferred = new ConcurrentLinkedQueue<Runnable>();

    public SASCollectorExecutor() {
        super(1);
        this.setRejectedExecutionHandler(this);
    }

    public void execute(Runnable command, boolean deferForSession) {
        if (deferForSession && InternalSingleton.get().getSessionData().getCurrentSessionId() == null) {
            SLog.w(this.TAG, "Session not yet established, deferring execution of %s", command.getClass().getSimpleName());
            this.deferred.add(command);
        } else {
            this.execute(command);
        }
    }

    @Override
    public void execute(Runnable command) {
        if (!(command instanceof BaseSASCollectorTask)) {
            SLog.e(this.TAG, (CharSequence)("Unrecognized task class: " + command.getClass().getName()), new Object[0]);
            return;
        }
        SLog.d(this.TAG, "Executing " + command.getClass().getName(), new Object[0]);
        super.execute(command);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        if (this.deferred.size() > 0 && InternalSingleton.get().getSessionData().getCurrentSessionId() != null) {
            SLog.d(this.TAG, "Session is established, executing %d deferred tasks", this.deferred.size());
            for (Runnable d : this.deferred) {
                this.execute(d);
            }
            this.deferred.clear();
        }
        super.afterExecute(r, t);
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        SLog.e(this.TAG, (CharSequence)("Execution rejection for " + r.getClass().getName()), new Object[0]);
    }
}

