/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.tasks;

import com.sas.mkt.mobile.sdk.SASCollector;
import com.sas.mkt.mobile.sdk.SASCollectorEvent;
import com.sas.mkt.mobile.sdk.domain.MobileEvent;
import com.sas.mkt.mobile.sdk.offline.OfflineEventManager;
import com.sas.mkt.mobile.sdk.tasks.BaseSASCollectorTask;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueueEventTask
extends BaseSASCollectorTask {
    private static final long TIMEOUT = 10000L;
    private static final long SLEEP = 500L;
    private final String TAG = QueueEventTask.class.getSimpleName();
    private Date date = null;
    private List<SASCollectorEvent> events = null;
    private MobileEvent.SessionIndicator sessionIndicator = MobileEvent.SessionIndicator.NONE;

    public QueueEventTask(List<SASCollectorEvent> events, MobileEvent.SessionIndicator sessionIndicator) {
        this.date = new Date();
        this.events = events;
        this.sessionIndicator = sessionIndicator;
    }

    public List<SASCollectorEvent> getEvents() {
        return this.events;
    }

    public MobileEvent.SessionIndicator getSessionIndicator() {
        return this.sessionIndicator;
    }

    protected MobileEvent createEvent(SASCollectorEvent event) {
        List<Map<String, String>> cartItems;
        MobileEvent evt = new MobileEvent();
        evt.setEventType(event.getEventKey());
        Map<String, String> eventMeta = event.getAttributes();
        if (eventMeta == null) {
            eventMeta = new HashMap<String, String>();
        }
        if ((cartItems = event.getCartItems()).size() > 0) {
            eventMeta.put("totalCartItems", cartItems.size() + "");
            int item = 1;
            for (Map<String, String> cartItem : cartItems) {
                StringBuilder b = new StringBuilder();
                String joinString = "";
                for (String key : cartItem.keySet()) {
                    String value = cartItem.get(key);
                    b.append(joinString).append(key).append("=").append(value);
                    joinString = "&";
                }
                eventMeta.put("cartitem." + item, b.toString());
                ++item;
            }
        }
        evt.setEventAttributes(eventMeta);
        evt.setSessionIndicator(this.sessionIndicator);
        evt.setEventDateTime(this.date);
        evt.setDeviceId(SASCollector.getInstance().getDeviceID());
        evt.setAppId(SASCollector.getInstance().getApplicationID());
        return evt;
    }

    @Override
    public void run() {
        try {
            ArrayList<MobileEvent> mobileEvents = new ArrayList<MobileEvent>();
            for (SASCollectorEvent event : this.events) {
                mobileEvents.add(this.createEvent(event));
                SLog.d(this.TAG, "Queuing event: %s", event.getEventKey());
            }
            OfflineEventManager.getInstance().push(mobileEvents);
        }
        catch (Exception e) {
            SLog.e(this.TAG, (CharSequence)"Error queuing event: %s", e.getMessage());
            SLog.fullException(this.TAG, "QueueEventTask", e);
        }
    }
}

