/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.tasks;

import com.sas.mkt.mobile.sdk.SASCollector;
import com.sas.mkt.mobile.sdk.domain.EventList;
import com.sas.mkt.mobile.sdk.domain.MobileEvent;
import com.sas.mkt.mobile.sdk.server.MidtierServices;
import com.sas.mkt.mobile.sdk.server.MidtierServicesException;
import com.sas.mkt.mobile.sdk.server.MidtierServicesFactory;
import com.sas.mkt.mobile.sdk.tasks.BaseSASCollectorTask;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;

public class PostEventsTask
extends BaseSASCollectorTask {
    private static final String TAG = PostEventsTask.class.getSimpleName();
    private ResultHandler handler;
    private List<MobileEvent> events;

    public PostEventsTask(ResultHandler handler, List<MobileEvent> events) {
        SLog.d(TAG, "PostEventsTask created.", new Object[0]);
        this.handler = handler;
        this.events = events;
    }

    @Override
    public void run() {
        SLog.d(TAG, "Execute PostEventsTask.", new Object[0]);
        try {
            TreeMap<Long, EventList> csiMap = new TreeMap<Long, EventList>();
            for (MobileEvent e : this.events) {
                EventList list = (EventList)csiMap.get(e.getcsi());
                if (list == null) {
                    list = new EventList();
                    csiMap.put(e.getcsi(), list);
                }
                list.add(e);
            }
            for (EventList list : csiMap.descendingMap().values()) {
                MidtierServices midtier = MidtierServicesFactory.newMidtierServices();
                SLog.d(PostEventsTask.class.getSimpleName(), String.format(Locale.getDefault(), "Posting %d events for CSI: %d", list.size(), ((MobileEvent)list.get(0)).getcsi()), new Object[0]);
                Collections.sort(list, new Comparator<MobileEvent>(){

                    @Override
                    public int compare(MobileEvent lhs, MobileEvent rhs) {
                        return lhs.getEventDateTime().compareTo(rhs.getEventDateTime());
                    }
                });
                try {
                    midtier.postEvents(list);
                    if (this.handler == null) continue;
                    this.handler.handleSuccess(list);
                }
                catch (MidtierServicesException e) {
                    SLog.e(TAG, (CharSequence)"Error posting events: %s::%s", e.getClass().getSimpleName(), e.getLocalizedMessage());
                    if (this.handler == null) continue;
                    this.handler.handleFailure(list, e);
                }
            }
        }
        catch (Throwable t) {
            SLog.e(t, TAG, "Error in background task: " + t.getLocalizedMessage(), new Object[0]);
            SASCollector.getInstance().shutdown();
        }
    }

    public static interface ResultHandler {
        public void handleSuccess(List<MobileEvent> var1);

        public void handleFailure(List<MobileEvent> var1, Exception var2);
    }
}

