/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.tasks;

import android.database.sqlite.SQLiteException;
import com.sas.mkt.mobile.sdk.database.EventsDataSource;
import com.sas.mkt.mobile.sdk.domain.MobileEvent;
import com.sas.mkt.mobile.sdk.tasks.BaseSASCollectorTask;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.util.List;

public class PersistEventsTask
extends BaseSASCollectorTask {
    private static final String TAG = PersistEventsTask.class.getSimpleName();
    private List<MobileEvent> events;

    public PersistEventsTask(List<MobileEvent> events) {
        this.events = events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        EventsDataSource db = EventsDataSource.getInstance();
        if (db == null) {
            SLog.w(TAG, "Offline event storage initialization failure.", new Object[0]);
            return;
        }
        EventsDataSource eventsDataSource = db;
        synchronized (eventsDataSource) {
            try {
                db.open();
                db.addEvents(this.events);
                db.close();
            }
            catch (SQLiteException e) {
                SLog.e(TAG, (CharSequence)"Error writing events to offline DB (%s): %s", ((Object)((Object)e)).getClass().getSimpleName(), e.getMessage());
            }
            catch (Throwable t) {
                SLog.e(TAG, (CharSequence)"Error persisting offline events.", new Object[0]);
            }
        }
    }
}

