/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.tasks;

import android.content.Context;
import android.location.Location;
import com.sas.mkt.mobile.sdk.InternalSingleton;
import com.sas.mkt.mobile.sdk.SASCollector;
import com.sas.mkt.mobile.sdk.domain.GeofenceContainer;
import com.sas.mkt.mobile.sdk.domain.SimpleGeofence;
import com.sas.mkt.mobile.sdk.loc.GeofenceManager;
import com.sas.mkt.mobile.sdk.server.MidtierServices;
import com.sas.mkt.mobile.sdk.server.MidtierServicesFactory;
import com.sas.mkt.mobile.sdk.tasks.BaseSASCollectorTask;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.util.ArrayList;

public class LoadGeofencesTask
extends BaseSASCollectorTask {
    private final String TAG = LoadGeofencesTask.class.getSimpleName();
    private Context context;
    private Location location;

    public LoadGeofencesTask(Context context, Location loc) {
        this.location = loc;
        this.context = context;
    }

    @Override
    public void run() {
        MidtierServices midtier = MidtierServicesFactory.newMidtierServices();
        try {
            ((InternalSingleton)SASCollector.getInstance()).disableBeaconScan();
            if (InternalSingleton.get().getAppEnvironment().hasPlayServices()) {
                GeofenceContainer container = midtier.getGeofences(this.location.getLatitude(), this.location.getLongitude());
                if (container != null) {
                    ArrayList<SimpleGeofence> fences = new ArrayList<SimpleGeofence>();
                    if (container.getRegions() != null) {
                        for (SimpleGeofence fence : container.getRegions()) {
                            fences.add(fence);
                        }
                    }
                    if (container.getBoundingRegion() != null) {
                        container.getBoundingRegion().setId("INDEX");
                        fences.add(container.getBoundingRegion());
                    }
                    GeofenceManager geofenceManager = new GeofenceManager();
                    geofenceManager.setGeofences(this.context, fences.toArray(new SimpleGeofence[0]));
                } else {
                    SLog.d(this.TAG, "No geofences available for this app.", new Object[0]);
                }
            } else {
                SLog.w(this.TAG, "Play services not available, geofences will not be queried.", new Object[0]);
            }
        }
        catch (Throwable t) {
            SLog.e(this.TAG, (CharSequence)("Error refreshing geofences: " + t.getLocalizedMessage()), new Object[0]);
            SLog.fullException(this.TAG, "Refreshing Geofences", t);
        }
    }
}

