/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.tasks;

import android.content.Context;
import android.util.Log;
import com.sas.mkt.mobile.sdk.DeviceAndApplicationInfoHelper;
import com.sas.mkt.mobile.sdk.InternalSingleton;
import com.sas.mkt.mobile.sdk.SASCollector;
import com.sas.mkt.mobile.sdk.domain.IdentityData;
import com.sas.mkt.mobile.sdk.server.MidtierServices;
import com.sas.mkt.mobile.sdk.server.MidtierServicesFactory;
import com.sas.mkt.mobile.sdk.tasks.BaseSASCollectorTask;
import java.util.Map;

public class IdentityTask
extends BaseSASCollectorTask {
    private final String TAG = IdentityTask.class.getSimpleName();
    private Context context;
    private String value;
    private String type;
    private String deviceId;
    private SASCollector.IdentityCallback callback;

    public IdentityTask(Context context, String value, String type, String deviceId, SASCollector.IdentityCallback callback) {
        this.context = context;
        this.value = value;
        this.type = type;
        this.deviceId = deviceId;
        this.callback = callback;
    }

    @Override
    public void run() {
        block3: {
            MidtierServices midtierServices = MidtierServicesFactory.newMidtierServices();
            try {
                Map<String, String> sessionVariables = DeviceAndApplicationInfoHelper.buildDeviceInfo(this.context);
                IdentityData identityData = new IdentityData();
                identityData.setType(this.type);
                identityData.setValue(this.value);
                identityData.setAppId(SASCollector.getInstance().getApplicationID());
                identityData.setLoadId(InternalSingleton.get().getSessionData().getCurrentLoadId());
                identityData.setVariables(sessionVariables);
                midtierServices.identity(this.deviceId, identityData);
                if (this.callback != null) {
                    this.callback.onComplete(true);
                }
            }
            catch (Throwable t) {
                Log.e((String)this.TAG, (String)("Error sending identity: " + t.getLocalizedMessage()));
                InternalSingleton.get().getSessionData().clearLastIdentity();
                if (this.callback == null) break block3;
                this.callback.onComplete(false);
            }
        }
    }
}

