/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.tasks;

import com.sas.mkt.mobile.sdk.InternalSingleton;
import com.sas.mkt.mobile.sdk.tasks.BaseSASCollectorTask;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.UUID;

public class DownloadRemoteImageTask
extends BaseSASCollectorTask {
    private static final String TAG = DownloadRemoteImageTask.class.getSimpleName();
    private static Object lock = new Object();
    private Callback callback;
    private String url;
    private String localFilePath;

    public DownloadRemoteImageTask(String url, Callback callback) {
        this.url = url;
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block44: {
            InputStream inputStream;
            FileOutputStream fileOutputStream;
            block42: {
                File remoteFilesDir;
                block40: {
                    block41: {
                        if (this.url == null || this.url.length() == 0) {
                            String message = "Invalid input URL: " + this.url;
                            SLog.e(TAG, (CharSequence)message, new Object[0]);
                            if (this.callback != null) {
                                this.callback.downloadFailure(message);
                            }
                            return;
                        }
                        fileOutputStream = null;
                        inputStream = null;
                        remoteFilesDir = InternalSingleton.get().getRemoteFilesDir();
                        if (remoteFilesDir.exists() || remoteFilesDir.mkdirs()) break block40;
                        String message = "Failed to create remote image dir structure at " + remoteFilesDir.getAbsolutePath();
                        SLog.e(TAG, (CharSequence)message, new Object[0]);
                        if (this.callback == null) break block41;
                        this.callback.downloadFailure(message);
                    }
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (Exception e) {
                        SLog.e(e, TAG, "Error closing remote download resources: " + e.getMessage(), new Object[0]);
                    }
                    if (this.callback != null && this.localFilePath != null) {
                        try {
                            this.callback.downloadComplete(this.localFilePath);
                        }
                        catch (Exception e) {
                            SLog.e(e, TAG, "Error executing download callback: %s", e.getMessage());
                        }
                    }
                    return;
                }
                File target = new File(remoteFilesDir, UUID.randomUUID().toString());
                fileOutputStream = new FileOutputStream(target);
                URL urlObj = new URL(this.url);
                SLog.d(TAG, "Downloading %s", urlObj);
                URLConnection conn = urlObj.openConnection();
                if (conn instanceof HttpURLConnection) {
                    HttpURLConnection httpConn = (HttpURLConnection)conn;
                    if (httpConn.getResponseCode() == 200) {
                        byte[] buffer = new byte[1024];
                        inputStream = conn.getInputStream();
                        int totalBytes = 0;
                        int rc = -1;
                        while ((rc = inputStream.read(buffer)) > 0) {
                            totalBytes += rc;
                            fileOutputStream.write(buffer, 0, rc);
                        }
                        SLog.d(TAG, "Download complete %d bytes", totalBytes);
                        this.localFilePath = target.getAbsolutePath();
                    } else {
                        String message = "Unexpected HTTP response: " + httpConn.getResponseCode();
                        SLog.e(TAG, (CharSequence)message, new Object[0]);
                        if (this.callback != null) {
                            this.callback.downloadFailure(message);
                        }
                    }
                    break block42;
                }
                String message = "Unexpected URLConnection type: " + conn.getClass().getName();
                SLog.e(TAG, (CharSequence)message, new Object[0]);
                if (this.callback == null) break block42;
                this.callback.downloadFailure(message);
            }
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                SLog.e(e, TAG, "Error closing remote download resources: " + e.getMessage(), new Object[0]);
            }
            if (this.callback != null && this.localFilePath != null) {
                try {
                    this.callback.downloadComplete(this.localFilePath);
                }
                catch (Exception e) {
                    SLog.e(e, TAG, "Error executing download callback: %s", e.getMessage());
                }
            }
            break block44;
            catch (Throwable e) {
                block43: {
                    try {
                        SLog.e(e, TAG, "Exception while downloading remote image.", new Object[0]);
                        if (this.callback == null) break block43;
                        this.callback.downloadFailure("Exception while downloading remote image: " + e.getClass().getName());
                    }
                    catch (Throwable throwable) {
                        try {
                            if (fileOutputStream != null) {
                                fileOutputStream.close();
                            }
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (Exception e2) {
                            SLog.e(e2, TAG, "Error closing remote download resources: " + e2.getMessage(), new Object[0]);
                        }
                        if (this.callback != null && this.localFilePath != null) {
                            try {
                                this.callback.downloadComplete(this.localFilePath);
                            }
                            catch (Exception e3) {
                                SLog.e(e3, TAG, "Error executing download callback: %s", e3.getMessage());
                            }
                        }
                        throw throwable;
                    }
                }
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception e4) {
                    SLog.e(e4, TAG, "Error closing remote download resources: " + e4.getMessage(), new Object[0]);
                }
                if (this.callback != null && this.localFilePath != null) {
                    try {
                        this.callback.downloadComplete(this.localFilePath);
                    }
                    catch (Exception e5) {
                        SLog.e(e5, TAG, "Error executing download callback: %s", e5.getMessage());
                    }
                }
            }
        }
    }

    public static interface Callback {
        public void downloadComplete(String var1);

        public void downloadFailure(String var1);
    }
}

