/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.tasks;

import android.util.Log;
import com.sas.mkt.mobile.sdk.InternalSingleton;
import com.sas.mkt.mobile.sdk.SASCollector;
import com.sas.mkt.mobile.sdk.SASCollectorEvent;
import com.sas.mkt.mobile.sdk.domain.MobileEvent;
import com.sas.mkt.mobile.sdk.server.MidtierServices;
import com.sas.mkt.mobile.sdk.server.MidtierServicesFactory;
import com.sas.mkt.mobile.sdk.tasks.BaseSASCollectorTask;

public class DetachIdentity
extends BaseSASCollectorTask {
    private final String TAG = DetachIdentity.class.getSimpleName();
    private SASCollector.DetachIdentityCallback callback;
    private String deviceId;
    private boolean willSendNewFocusEvent;
    private boolean crossChannel;

    public DetachIdentity(String deviceId, boolean willSendNewFocusEvent, SASCollector.DetachIdentityCallback callback, boolean crossChannel) {
        this.callback = callback;
        this.deviceId = deviceId;
        this.willSendNewFocusEvent = willSendNewFocusEvent;
        this.crossChannel = crossChannel;
    }

    @Override
    public void run() {
        block4: {
            MidtierServices midtierServices = MidtierServicesFactory.newMidtierServices();
            try {
                midtierServices.detachIdentity(this.deviceId, this.crossChannel);
                if (this.willSendNewFocusEvent) {
                    InternalSingleton.get().getSessionData().setFirstSession(true);
                    InternalSingleton.get().addAppEventInternal(new SASCollectorEvent("focus", null), MobileEvent.SessionIndicator.FORCE_NEW_SESSION);
                }
                if (this.callback != null) {
                    this.callback.onComplete(true);
                }
            }
            catch (Throwable t) {
                Log.e((String)this.TAG, (String)("Error detaching identity: " + t.getLocalizedMessage()));
                if (this.callback == null) break block4;
                this.callback.onComplete(false);
            }
        }
    }
}

