/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.tasks;

import com.sas.mkt.mobile.sdk.InternalSingleton;
import com.sas.mkt.mobile.sdk.tasks.BaseSASCollectorTask;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.io.File;

public class CleanRemoteImagesTask
extends BaseSASCollectorTask {
    private final String TAG = CleanRemoteImagesTask.class.getSimpleName();

    @Override
    public void run() {
        SLog.d(this.TAG, "Begin remote image cleanup...", new Object[0]);
        try {
            File dir = InternalSingleton.get().getRemoteFilesDir();
            if (!dir.exists()) {
                SLog.d(this.TAG, "Remote image dir does not exist: " + dir.getAbsolutePath(), new Object[0]);
            }
            int count = 0;
            File[] files = dir.listFiles();
            if (files != null && files.length > 0) {
                for (File file : files) {
                    long age = System.currentTimeMillis() - file.lastModified();
                    if (age <= 86400000L) continue;
                    try {
                        if (!file.delete()) {
                            SLog.e(this.TAG, (CharSequence)("Failed to clean up remote image file: " + file.getAbsolutePath()), new Object[0]);
                            continue;
                        }
                        ++count;
                    }
                    catch (Throwable t) {
                        SLog.e(this.TAG, (CharSequence)("Error cleaning up remote image file: " + file.getAbsolutePath() + " :: " + t.getClass().getSimpleName() + " :: " + t.getMessage()), new Object[0]);
                    }
                }
            }
            SLog.d(this.TAG, "Cleanup completed.  Deleted " + count, new Object[0]);
        }
        catch (Throwable t) {
            SLog.e(this.TAG, (CharSequence)("Error cleaning up remote files: " + t.getClass().getSimpleName() + " :: " + t.getMessage()), new Object[0]);
        }
    }
}

