/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.tasks;

import android.os.SystemClock;
import com.sas.mkt.mobile.sdk.SASCollector;
import com.sas.mkt.mobile.sdk.domain.AdRequestRedirect;
import com.sas.mkt.mobile.sdk.domain.ErrorData;
import com.sas.mkt.mobile.sdk.server.MidtierServices;
import com.sas.mkt.mobile.sdk.server.MidtierServicesException;
import com.sas.mkt.mobile.sdk.server.MidtierServicesFactory;
import com.sas.mkt.mobile.sdk.tasks.BaseSASCollectorTask;
import com.sas.mkt.mobile.sdk.util.SLog;

public class AdRequestRedirectTask
extends BaseSASCollectorTask {
    public static final String TAG = AdRequestRedirectTask.class.getSimpleName();
    private static final long SESSION_WAIT_SLEEP = 500L;
    private static final long SESSION_WAIT_TIMEOUT = 10000L;
    private String spotId;
    private ResultHandler handler;
    private MidtierServicesException exception = null;
    private String redirectUrl = null;

    public AdRequestRedirectTask(String spotId, ResultHandler handler) {
        this.spotId = spotId;
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MidtierServices midtier = MidtierServicesFactory.newMidtierServices();
        try {
            String appId;
            long timeout = 10000L;
            while (!midtier.hasSession()) {
                SLog.d(TAG, "Waiting for session...", new Object[0]);
                SystemClock.sleep((long)500L);
                if ((timeout -= 500L) > 0L) continue;
                ErrorData errorData = new ErrorData();
                errorData.setDetailedMessage("Timeout waiting for session to establish.");
                this.exception = new MidtierServicesException(errorData);
                return;
            }
            String deviceId = SASCollector.getInstance().getDeviceID();
            AdRequestRedirect redirect = midtier.getAdRequestRedirect(this.spotId, deviceId, appId = SASCollector.getInstance().getApplicationID());
            if (redirect != null) {
                this.redirectUrl = redirect.getUrl();
            } else {
                SLog.e(TAG, (CharSequence)"Invalid response for ad redirect.", new Object[0]);
            }
        }
        catch (MidtierServicesException e) {
            if (e.getErrorData().getCode() == 404) {
                SLog.e(TAG, (CharSequence)"Spot ID %s not found.", this.spotId);
            } else {
                SLog.e(TAG, (CharSequence)("Error getting Ad redirect: " + e.getLocalizedMessage()), new Object[0]);
                this.exception = e;
            }
        }
        catch (Throwable t) {
            this.exception = new MidtierServicesException(t);
        }
        finally {
            if (this.handler != null) {
                if (this.exception != null) {
                    this.handler.handleError(this.exception);
                } else {
                    this.handler.handleResult(this.redirectUrl);
                }
            }
        }
    }

    public static interface ResultHandler {
        public void handleResult(String var1);

        public void handleError(MidtierServicesException var1);
    }
}

