/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.server;

import android.net.Uri;
import android.webkit.CookieManager;
import com.sas.mkt.mobile.sdk.InternalSingleton;
import com.sas.mkt.mobile.sdk.JsonHandler;
import com.sas.mkt.mobile.sdk.SASCollector;
import com.sas.mkt.mobile.sdk.domain.AdRequestRedirect;
import com.sas.mkt.mobile.sdk.domain.ErrorData;
import com.sas.mkt.mobile.sdk.domain.EventList;
import com.sas.mkt.mobile.sdk.domain.GeofenceContainer;
import com.sas.mkt.mobile.sdk.domain.IdentityData;
import com.sas.mkt.mobile.sdk.domain.MobileEvent;
import com.sas.mkt.mobile.sdk.domain.SessionData;
import com.sas.mkt.mobile.sdk.domain.SimpleGeofence;
import com.sas.mkt.mobile.sdk.domain.TokenData;
import com.sas.mkt.mobile.sdk.domain.VersionedAPIData;
import com.sas.mkt.mobile.sdk.offline.OfflineEventManager;
import com.sas.mkt.mobile.sdk.server.HttpURLConnectionFactory;
import com.sas.mkt.mobile.sdk.server.MidtierServicesException;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLException;

public class MidtierServices {
    private static final String TAG = MidtierServices.class.getSimpleName();
    private static final String REST_ENDPOINT_EVENTS = "e";
    private static final String REST_ENDPOINT_GEOFENCES = "geofences";
    private static final String REST_ENDPOINT_SPOT = "spots";
    private static final String REST_ENDPOINT_PUSH_TOKEN = "tokens";
    private static final String REST_ENDPOINT_DEVICES = "device";
    private static final String REST_ENDPOINT_PARAM_LATITUDE = "latitude";
    private static final String REST_ENDPOINT_PARAM_LONGITUDE = "longitude";
    private static final String HTTP_HEADER_COOKIE = "Cookie";
    private static final String HTTP_HEADER_SET_COOKIE = "Set-Cookie";
    private static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HTTP_HEADER_CONTENT_LENGTH = "Content-Length";
    private static final String HTTP_HEADER_ACCEPT = "Accept";
    private static final String HTTP_HEADER_USER_AGENT = "User-Agent";
    private static final String COOKIE_SI_M_SID = "_SI_M_SID";
    private static final String HTTP_DEFAULT_CONTENT_TYPE = "application/json";
    private static final String HTTP_USER_AGENT = "SASCollector";
    private JsonHandler jsonHandler = new JsonHandler();
    private static MidtierServices instance;

    public static MidtierServices get() {
        if (instance == null) {
            instance = new MidtierServices();
        }
        return instance;
    }

    static void inject(MidtierServices instance) {
    }

    MidtierServices() {
    }

    public boolean hasSession() throws MidtierServicesException {
        String url = this.getUriBuilder(new String[0]).toString();
        SLog.d(TAG, "Checking for cookie for URL " + url, new Object[0]);
        String cookie = CookieManager.getInstance().getCookie(url);
        return cookie == null ? false : cookie.contains(COOKIE_SI_M_SID);
    }

    public boolean checkConnection() throws MidtierServicesException {
        try {
            String host = this.getServerHost();
            SLog.d(TAG, "Resolving host " + host, new Object[0]);
            InetAddress addr = InetAddress.getByName(host);
            SLog.d(TAG, "Resolved to " + addr.getHostAddress(), new Object[0]);
            return true;
        }
        catch (IOException e) {
            SLog.i(TAG, "Connection unavailable: " + e.getLocalizedMessage(), new Object[0]);
            return false;
        }
    }

    private String getServerHost() throws MidtierServicesException {
        return this.getBaseServerURL().getHost();
    }

    private URL getBaseServerURL() throws MidtierServicesException {
        try {
            String tagServer = SASCollector.getInstance().getTagServer();
            if (tagServer != null && tagServer.trim().length() > 0) {
                SLog.d(TAG, "Using base server URL: " + tagServer, new Object[0]);
                return new URL(tagServer);
            }
            ErrorData ed = new ErrorData();
            ed.setCode(-1);
            ed.setMessage("Invalid tag server URL");
            ed.setDetailedMessage("Invalid tag server URL (" + tagServer + ")");
            throw new MidtierServicesException(ed);
        }
        catch (MalformedURLException e) {
            throw new MidtierServicesException(e);
        }
    }

    private Uri.Builder getUriBuilder(String ... append) throws MidtierServicesException {
        Uri.Builder builder = Uri.parse((String)SASCollector.getInstance().getTagServer()).buildUpon();
        if (append != null) {
            for (String a : append) {
                builder.appendPath(a);
            }
        }
        return builder;
    }

    public void postEvent(MobileEvent event) throws MidtierServicesException {
        EventList mobileEvents = new EventList();
        mobileEvents.add(event);
        this.postEvents(mobileEvents);
    }

    public void postEvents(EventList events) throws MidtierServicesException {
        Uri uri = this.getUriBuilder(REST_ENDPOINT_EVENTS, SASCollector.getInstance().getTenantID()).build();
        SessionData sessionData = InternalSingleton.get().getSessionData();
        for (MobileEvent event : events) {
            if (event.getSessionId() != null) continue;
            event.setSessionId(sessionData.getCurrentSessionId());
        }
        this.executeHttp(HttpMethod.POST, uri, events, null);
    }

    public AdRequestRedirect getAdRequestRedirect(String spotId, String deviceId, String appId) throws MidtierServicesException {
        Uri uri = this.getUriBuilder(REST_ENDPOINT_SPOT, SASCollector.getInstance().getTenantID(), deviceId, appId, spotId).build();
        AdRequestRedirect result = (AdRequestRedirect)this.executeHttp(HttpMethod.GET, uri, null, AdRequestRedirect.class);
        return result;
    }

    public GeofenceContainer getGeofences(double latitude, double longitude) throws MidtierServicesException {
        GeofenceContainer result = null;
        Uri uri = this.getUriBuilder(REST_ENDPOINT_GEOFENCES, SASCollector.getInstance().getTenantID(), SASCollector.getInstance().getApplicationID()).appendQueryParameter(REST_ENDPOINT_PARAM_LATITUDE, Double.toString(latitude)).appendQueryParameter(REST_ENDPOINT_PARAM_LONGITUDE, Double.toString(longitude)).build();
        try {
            result = (GeofenceContainer)this.executeHttp(HttpMethod.GET, uri, null, GeofenceContainer.class);
        }
        catch (MidtierServicesException e) {
            if (e.getErrorData().getCode() == 404) {
                SLog.d(TAG, "No fences registered for tenant " + SASCollector.getInstance().getTenantID() + " application " + SASCollector.getInstance().getApplicationID(), new Object[0]);
                result = new GeofenceContainer();
                result.setRegions(new SimpleGeofence[0]);
            }
            SLog.d(TAG, "Exception getting geofences: " + e.getErrorData().getCode(), new Object[0]);
            throw e;
        }
        return result;
    }

    public void updateToken(String deviceId, String token, String appId) throws MidtierServicesException {
        TokenData tokenData = new TokenData();
        tokenData.setDeviceId(deviceId);
        tokenData.setToken(String.format("%s-%s", "Android", token));
        tokenData.setAppId(appId);
        this.executeHttp(HttpMethod.PUT, this.getUriBuilder(new String[0]).appendPath(REST_ENDPOINT_PUSH_TOKEN).appendPath(SASCollector.getInstance().getTenantID()).appendPath(deviceId).build(), tokenData, null);
    }

    public void detachIdentity(String deviceId, boolean crossChannel) throws MidtierServicesException {
        this.executeHttp(HttpMethod.DELETE, this.getUriBuilder(new String[0]).appendPath(REST_ENDPOINT_DEVICES).appendPath(SASCollector.getInstance().getTenantID()).appendPath(deviceId).appendQueryParameter("crossChannel", Boolean.toString(crossChannel).toLowerCase()).build(), null, null);
    }

    public void identity(String deviceId, IdentityData identityData) throws MidtierServicesException {
        this.executeHttp(HttpMethod.POST, this.getUriBuilder(new String[0]).appendPath(REST_ENDPOINT_DEVICES).appendPath(SASCollector.getInstance().getTenantID()).appendPath(deviceId).build(), identityData, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T executeHttp(HttpMethod method, Uri uri, Object requestData, Class<?> c) throws MidtierServicesException {
        InputStreamReader reader;
        HttpURLConnection httpURLConnection;
        block48: {
            SLog.d(TAG, "Outbound request: %s %s", method.toString().toUpperCase(), uri.toString());
            String contentType = HTTP_DEFAULT_CONTENT_TYPE;
            String accept = null;
            httpURLConnection = null;
            try {
                MidtierServicesException ex;
                ErrorData error_data;
                VersionedAPIData annotation;
                URL url = new URL(uri.toString());
                httpURLConnection = HttpURLConnectionFactory.getInstance().open(url);
                httpURLConnection.setRequestMethod(method.toString().toUpperCase());
                byte[] outBuffer = null;
                if (requestData != null) {
                    annotation = requestData.getClass().getAnnotation(VersionedAPIData.class);
                    if (annotation != null) {
                        contentType = annotation.contentType();
                    }
                    SLog.d(TAG, "JSON data for %s : %s", requestData == null ? "null" : requestData.getClass().getName(), this.jsonHandler.toJson(requestData));
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    OutputStreamWriter writer = new OutputStreamWriter(byteArrayOutputStream);
                    this.jsonHandler.toJson(requestData, writer);
                    writer.flush();
                    outBuffer = byteArrayOutputStream.toByteArray();
                    int contentLength = outBuffer == null ? 0 : outBuffer.length;
                    SLog.d(TAG, "Content-Length: %d", contentLength);
                    if (contentLength == 0) {
                        SLog.d(TAG, "Empty content", new Object[0]);
                    }
                    httpURLConnection.setRequestProperty(HTTP_HEADER_CONTENT_LENGTH, Integer.toString(contentLength));
                    httpURLConnection.setDoOutput(true);
                }
                if (c != null) {
                    annotation = c.getAnnotation(VersionedAPIData.class);
                    if (annotation != null) {
                        accept = annotation.contentType();
                    }
                    httpURLConnection.setDoInput(true);
                }
                if (!CookieManager.getInstance().acceptCookie()) {
                    SLog.w(TAG, "Unable to accept session cookie.", new Object[0]);
                }
                String cookie = CookieManager.getInstance().getCookie(url.toString());
                httpURLConnection.setRequestProperty(HTTP_HEADER_COOKIE, cookie);
                httpURLConnection.setRequestProperty(HTTP_HEADER_CONTENT_TYPE, contentType);
                httpURLConnection.setRequestProperty(HTTP_HEADER_USER_AGENT, HTTP_USER_AGENT);
                if (accept != null) {
                    httpURLConnection.setRequestProperty(HTTP_HEADER_ACCEPT, accept);
                }
                if (outBuffer != null) {
                    httpURLConnection.getOutputStream().write(outBuffer);
                }
                int rc = httpURLConnection.getResponseCode();
                SLog.d(TAG, "Response Code: %d", rc);
                Map<String, List<String>> responseCookies = httpURLConnection.getHeaderFields();
                for (Map.Entry<String, List<String>> entry : responseCookies.entrySet()) {
                    if (!HTTP_HEADER_SET_COOKIE.equals(entry.getKey())) continue;
                    for (String value : entry.getValue()) {
                        String[] parts;
                        if (value.indexOf(COOKIE_SI_M_SID) != -1 && (parts = value.split(";")) != null) {
                            for (String part : parts) {
                                String[] subParts = part.split("=");
                                SLog.d(TAG, "Part %s %d", part, subParts.length);
                                if (subParts == null || subParts.length != 2 || !COOKIE_SI_M_SID.equals(subParts[0])) continue;
                                String[] splitValue = subParts[1].split("\\.");
                                SLog.d(TAG, "Subpart %s %d", subParts[1], splitValue.length);
                                if (splitValue == null || splitValue.length != 3) break;
                                try {
                                    SessionData sessionData = InternalSingleton.get().getSessionData();
                                    sessionData.setCurrentSessionId(splitValue[0]);
                                    if (splitValue[1].endsWith("\"")) {
                                        splitValue[1] = splitValue[1].substring(0, splitValue[1].length() - 2);
                                    }
                                    if (splitValue[1].startsWith("\"")) {
                                        splitValue[1] = splitValue[1].substring(1);
                                    }
                                    if (splitValue[2].endsWith("\"")) {
                                        splitValue[2] = splitValue[2].substring(0, splitValue[2].length() - 2);
                                    }
                                    if (splitValue[2].startsWith("\"")) {
                                        splitValue[2] = splitValue[2].substring(1);
                                    }
                                    long timeout = (long)Integer.parseInt(splitValue[1]) * 60000L;
                                    long maxSession = (long)Integer.parseInt(splitValue[2]) * 60000L;
                                    SLog.d(TAG, "Timeout update session: %d max: %d", timeout, maxSession);
                                    OfflineEventManager.sessionTimeout = timeout;
                                    OfflineEventManager.sessionMax = maxSession;
                                }
                                catch (NumberFormatException e) {
                                    SLog.w(TAG, "Error parsing session timeouts: " + e.getMessage(), new Object[0]);
                                }
                                break;
                            }
                        }
                        SLog.d(TAG, "Setting cookie %s %s", url.toString(), value);
                        CookieManager.getInstance().setCookie(url.toString(), value);
                    }
                }
                if (rc / 100 == 2) {
                    Map.Entry<String, List<String>> entry;
                    reader = new InputStreamReader(httpURLConnection.getInputStream());
                    if (c != null) {
                        entry = this.jsonHandler.fromJson(reader, c);
                        return (T)entry;
                    }
                    entry = null;
                    return (T)entry;
                }
                if (rc == 422) break block48;
                if (rc == 404) {
                    error_data = new ErrorData();
                    error_data.setCode(rc);
                    ex = new MidtierServicesException(error_data);
                    ex.setUrl(url.toString());
                    throw ex;
                }
                SLog.e(TAG, (CharSequence)("Unexpected status code from server: " + rc), new Object[0]);
                error_data = new ErrorData();
                error_data.setCode(rc);
                ex = new MidtierServicesException(error_data);
                ex.setUrl(url.toString());
                throw ex;
            }
            catch (SSLException e) {
                SLog.e(TAG, (CharSequence)("SSLException (" + e + ")in HTTPS comms: " + e.getMessage()), new Object[0]);
                SASCollector.getInstance().shutdown();
                throw new MidtierServicesException(e);
            }
            catch (MalformedURLException e) {
                throw new MidtierServicesException(e);
            }
            catch (MidtierServicesException e) {
                throw e;
            }
            catch (FileNotFoundException e) {
                MidtierServicesException midtierServicesException = new MidtierServicesException(e);
                midtierServicesException.getErrorData().setCode(404);
                throw midtierServicesException;
            }
            catch (Exception e) {
                throw new MidtierServicesException(e);
            }
        }
        SLog.d(TAG, "Global shutdown signaled.", new Object[0]);
        SASCollector.getInstance().shutdown();
        reader = null;
        return (T)reader;
        finally {
            reader.close();
        }
        finally {
            if (httpURLConnection != null) {
                try {
                    httpURLConnection.disconnect();
                }
                catch (Exception e) {
                    SLog.e(TAG, (CharSequence)("Error closing HTTP connection: " + e.getMessage()), new Object[0]);
                }
            }
        }
    }

    private static enum HttpMethod {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

