/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.server;

import android.os.Build;
import com.sas.mkt.mobile.sdk.util.SLog;
import com.sas.mkt.mobile.sdk.util.TLSSocketFactory;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;

public class HttpURLConnectionFactory {
    private final String TAG = HttpURLConnectionFactory.class.getSimpleName();
    private static HttpURLConnectionFactory instance;

    public static HttpURLConnectionFactory getInstance() {
        if (instance == null) {
            instance = new HttpURLConnectionFactory();
        }
        return instance;
    }

    private HttpURLConnectionFactory() {
    }

    public HttpURLConnection open(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection sconn = (HttpsURLConnection)conn;
            if (Build.VERSION.SDK_INT <= 19) {
                SLog.d(this.TAG, "Using custom SSL socket factory for Android 4.4 connection.", new Object[0]);
                try {
                    sconn.setSSLSocketFactory(new TLSSocketFactory());
                }
                catch (Exception e) {
                    SLog.e(this.TAG, (CharSequence)("Error establishing secure TLS channel: " + e.getMessage()), new Object[0]);
                    throw new IOException(e);
                }
            }
        } else {
            SLog.w(this.TAG, "Opening unsecured HTTP channel.", new Object[0]);
        }
        return conn;
    }
}

