/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.offline;

import android.app.Application;
import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.os.SystemClock;
import com.sas.mkt.mobile.sdk.DeviceAndApplicationInfoHelper;
import com.sas.mkt.mobile.sdk.InternalSingleton;
import com.sas.mkt.mobile.sdk.SASCollector;
import com.sas.mkt.mobile.sdk.database.EventsDataSource;
import com.sas.mkt.mobile.sdk.domain.MobileEvent;
import com.sas.mkt.mobile.sdk.domain.SessionData;
import com.sas.mkt.mobile.sdk.server.MidtierServices;
import com.sas.mkt.mobile.sdk.server.MidtierServicesException;
import com.sas.mkt.mobile.sdk.server.MidtierServicesFactory;
import com.sas.mkt.mobile.sdk.tasks.PersistEventsTask;
import com.sas.mkt.mobile.sdk.tasks.PostEventsTask;
import com.sas.mkt.mobile.sdk.util.AndroidXorIdProvider;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;

public class OfflineEventManager
implements Runnable,
PostEventsTask.ResultHandler {
    private static final String PREF_CSI = OfflineEventManager.class.getName() + ".csi";
    public static long sessionMax = 600000L;
    public static long sessionTimeout = 120000L;
    private final String TAG = OfflineEventManager.class.getSimpleName();
    private static final long SLEEP_PERIOD = 500L;
    private static long FOCUS_LOAD_TIMEOUT = 5000L;
    private static OfflineEventManager instance;
    private AtomicBoolean running = new AtomicBoolean(false);
    private boolean cleanDB = false;
    private AndroidXorIdProvider xorIdProvider = null;
    private List<MobileEvent> buffer = new Vector<MobileEvent>();

    private OfflineEventManager() {
        if (instance != null) {
            SLog.w(this.TAG, "Duplicate OfflineEventManager detected.", new Object[0]);
            instance.setRunning(false);
        }
        instance = this;
        this.xorIdProvider = new AndroidXorIdProvider();
    }

    public static synchronized OfflineEventManager getInstance() {
        if (instance == null) {
            instance = new OfflineEventManager();
        }
        return instance;
    }

    public void setRunning(boolean value) {
        this.running.set(value);
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public void stop() {
        SLog.d(this.TAG, "Stopping.", new Object[0]);
        this.setRunning(false);
        this.buffer.clear();
        this.cleanDB = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setRunning(true);
        SLog.d(this.TAG, "Event Manager is running.", new Object[0]);
        while (this.isRunning()) {
            ArrayList<MobileEvent> bufferCopy = new ArrayList<MobileEvent>();
            List<MobileEvent> list = this.buffer;
            synchronized (list) {
                bufferCopy.addAll(this.buffer);
                this.buffer.clear();
            }
            MidtierServices midtier = MidtierServicesFactory.newMidtierServices();
            boolean midtierAvailable = false;
            try {
                midtierAvailable = midtier.checkConnection();
            }
            catch (MidtierServicesException e) {
                SLog.e(this.TAG, (CharSequence)("Error checking server connection: " + e.getLocalizedMessage()), new Object[0]);
            }
            if (midtierAvailable) {
                SLog.d(this.TAG, "Server is available.", new Object[0]);
                if (bufferCopy.size() > 0) {
                    SLog.d(this.TAG, "Flushing " + bufferCopy.size() + " buffered events.", new Object[0]);
                    InternalSingleton.exec(new PostEventsTask(this, bufferCopy));
                } else {
                    SLog.d(this.TAG, "Buffer was empty.", new Object[0]);
                }
                List<Object> offlineEvents = new ArrayList(0);
                if (!this.cleanDB) {
                    EventsDataSource db = EventsDataSource.getInstance();
                    if (db == null) {
                        SLog.w(this.TAG, "Offline event storage initialization failure.", new Object[0]);
                        break;
                    }
                    EventsDataSource eventsDataSource = db;
                    synchronized (eventsDataSource) {
                        try {
                            db.open();
                            offlineEvents = db.getRecentEvents();
                            db.deleteAll();
                            this.cleanDB = true;
                            db.close();
                        }
                        catch (SQLiteException e) {
                            SLog.e(this.TAG, (CharSequence)"Error accessing offline DB (%s): {%s}", ((Object)((Object)e)).getClass().getSimpleName(), e.getMessage());
                            offlineEvents = new ArrayList(0);
                            this.cleanDB = false;
                        }
                    }
                    SLog.d(this.TAG, String.format(Locale.getDefault(), "Pulled %d from DB", offlineEvents.size()), new Object[0]);
                    if (offlineEvents.size() > 0) {
                        InternalSingleton.exec(new PostEventsTask(this, offlineEvents));
                    }
                } else {
                    SLog.d(this.TAG, "DB is clean.", new Object[0]);
                }
            } else {
                SLog.d(this.TAG, "Server is unavailable.", new Object[0]);
                if (bufferCopy.size() > 0) {
                    SLog.d(this.TAG, "Persisting " + bufferCopy.size() + " events", new Object[0]);
                    InternalSingleton.get().getCommonExecutor().execute(new PersistEventsTask(bufferCopy));
                    this.cleanDB = false;
                }
            }
            if (this.isRunning()) {
                SystemClock.sleep((long)500L);
            }
            if (!this.isRunning() || this.buffer.size() != 0) continue;
            List<MobileEvent> list2 = this.buffer;
            synchronized (list2) {
                try {
                    SLog.d(this.TAG, "No more events to send, entering deep sleep.", new Object[0]);
                    this.buffer.wait();
                    SLog.d(this.TAG, "Woke up from deep sleep.", new Object[0]);
                }
                catch (InterruptedException e) {
                    SLog.w(this.TAG, "Interrupted during deep sleep: " + e.getLocalizedMessage(), new Object[0]);
                }
            }
        }
        this.setRunning(false);
        instance = null;
        SLog.d(this.TAG, "Stopped.", new Object[0]);
    }

    private void decorateEvent(MobileEvent e) {
        boolean sessionTimedOut;
        SessionData sessionData = InternalSingleton.get().getSessionData();
        long t = e.getEventDateTime().getTime();
        String flags = e.getEventDetail("flags");
        boolean newLoad = false;
        boolean bl = sessionTimedOut = t - sessionData.getLastEvent() > sessionTimeout || t - sessionData.getLastNewSession() > sessionMax;
        if (sessionTimedOut) {
            SLog.d(this.TAG, "Session timed out.", new Object[0]);
        }
        MobileEvent.SessionIndicator sessionIndicator = e.getSessionIndicator();
        SLog.d(this.TAG, "Session indicator is " + sessionIndicator.name(), new Object[0]);
        if (sessionIndicator == MobileEvent.SessionIndicator.NO_NEW_SESSION) {
            e.setSessionId(e.getDeviceId().replace("-", ""));
            e.getEventAttributes().put("FromMobileWorker", "yes");
        } else if (sessionIndicator == MobileEvent.SessionIndicator.FORCE_NEW_SESSION || sessionTimedOut || !e.getDeviceId().equals(sessionData.getLastDeviceId())) {
            SLog.d(this.TAG, "Starting new session. %d %d %d %d %s %s", t - sessionData.getLastEvent(), t - sessionData.getLastNewSession(), sessionTimeout, sessionMax, InternalSingleton.get().getSessionData().getLastDeviceId(), e.getDeviceId());
            sessionData.setCurrentCSI(System.currentTimeMillis());
            sessionData.setLastNewSession(t);
            sessionData.setLastDeviceId(e.getDeviceId());
            sessionData.setCurrentSessionId(null);
            e.getEventAttributes().putAll(DeviceAndApplicationInfoHelper.buildDeviceInfo((Context)InternalSingleton.get().getApplication()));
            flags = flags == null ? "ns" : flags + '|' + "ns";
            newLoad = true;
        } else if ("identity".equals(e.getEventType())) {
            e.getEventAttributes().putAll(DeviceAndApplicationInfoHelper.buildDeviceInfo((Context)InternalSingleton.get().getApplication()));
        }
        if (sessionData.getCurrentLoadId() == null || "load".equals(e.getEventType())) {
            newLoad = true;
        }
        if (sessionIndicator != MobileEvent.SessionIndicator.NO_NEW_SESSION && newLoad) {
            sessionData.setCurrentLoadId(this.xorIdProvider.generateLoadId());
            String loadUri = e.getEventDetail("uri");
            if (loadUri == null) {
                loadUri = sessionData.getLastLoadUri() != null ? sessionData.getLastLoadUri() : "";
            } else {
                sessionData.setLastLoadUri(loadUri);
            }
            loadUri = String.format("%s/%s", SASCollector.getInstance().getApplicationID(), loadUri);
            e.getEventAttributes().put("uri", loadUri);
            flags = flags == null ? "nl" : flags + '|' + "nl";
        }
        if (flags != null) {
            e.getEventAttributes().put("flags", flags);
        }
        if (sessionIndicator != MobileEvent.SessionIndicator.NO_NEW_SESSION) {
            e.setLoadId(sessionData.getCurrentLoadId());
            sessionData.setLastEvent(e.getEventDateTime().getTime());
        }
        e.setcsi(sessionData.getCurrentCSI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int peek() {
        if (this.isRunning()) {
            List<MobileEvent> list = this.buffer;
            synchronized (list) {
                SLog.d(this.TAG, "Peek buffer wake up.", new Object[0]);
                this.buffer.notify();
            }
        }
        return this.buffer == null ? 0 : this.buffer.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean push(List<MobileEvent> events) {
        List<MobileEvent> list = this.buffer;
        synchronized (list) {
            for (MobileEvent event : events) {
                this.decorateEvent(event);
                SLog.d(this.TAG, "Adding event (%s) to buffer.", event.getEventType());
                this.buffer.add(event);
            }
            this.buffer.notify();
            return true;
        }
    }

    @Override
    public void handleSuccess(List<MobileEvent> successfulEvents) {
        if (SASCollector.getInstance().isInitialized()) {
            InternalSingleton singleton;
            SLog.d(this.TAG, successfulEvents.size() + " Events successfully posted.", new Object[0]);
            Application app = InternalSingleton.get().getApplication();
            if (app != null && (singleton = InternalSingleton.get()).getEventCallback() != null) {
                for (MobileEvent event : successfulEvents) {
                    InternalSingleton.get().getEventCallback().eventDelivered(event.getEventType());
                }
            }
        }
    }

    @Override
    public void handleFailure(List<MobileEvent> failedEvents, Exception exception) {
        SLog.w(this.TAG, "Failed to post events to server, storing " + failedEvents.size() + " events. (" + exception.getLocalizedMessage() + ")", new Object[0]);
        InternalSingleton.get().getCommonExecutor().execute(new PersistEventsTask(failedEvents));
        this.cleanDB = false;
    }
}

