/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.loc;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationManager;
import android.os.Parcelable;
import com.sas.mkt.mobile.sdk.InternalSingleton;
import com.sas.mkt.mobile.sdk.SASCollectorIntentService;
import com.sas.mkt.mobile.sdk.tasks.LoadGeofencesTask;
import com.sas.mkt.mobile.sdk.util.SLog;

public class LocationHelper {
    private static final String TAG = LocationHelper.class.getSimpleName();
    private boolean syncLocation = true;

    public void resetState() {
        this.syncLocation = true;
    }

    public void requestLocationUpdate(Context context) {
        if (context == null) {
            SLog.e(TAG, (CharSequence)"Null context provided to requestLocationUpdate", new Object[0]);
            return;
        }
        if (!this.syncLocation) {
            SLog.d(TAG, "App is already resident, no location update.", new Object[0]);
            return;
        }
        if (!InternalSingleton.get().getAppEnvironment().hasSDKIntentService()) {
            SLog.e(TAG, (CharSequence)"SASCollectorIntentService is not registered, unable to request location update.", new Object[0]);
            return;
        }
        if (context.checkCallingOrSelfPermission("android.permission.ACCESS_FINE_LOCATION") != 0) {
            SLog.e(TAG, (CharSequence)"ACCESS_FINE_LOCATION permission is not granted, unable to request location update.", new Object[0]);
            return;
        }
        this.syncLocation = false;
        this.requestLocationUpdateViaLocationManager(context);
    }

    private void requestLocationUpdateViaLocationManager(Context context) {
        Activity currentActivity = InternalSingleton.get().getCurrentActivity();
        if (currentActivity != null && currentActivity.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") != 0) {
            SLog.e(TAG, (CharSequence)"Location permission not granted, unable request location update.", new Object[0]);
            return;
        }
        SLog.d(TAG, "Requesting location update via location manager.", new Object[0]);
        Intent intent = new Intent(context, SASCollectorIntentService.class);
        intent.setAction(SASCollectorIntentService.ACTION_LOCATION_UPDATE);
        LocationManager lm = (LocationManager)context.getSystemService("location");
        Location loc = lm.getLastKnownLocation("gps");
        if (loc != null && System.currentTimeMillis() - loc.getTime() < 60000L) {
            SLog.d(TAG, "Using cached GPS location: " + loc.getAccuracy(), new Object[0]);
            InternalSingleton.exec(new LoadGeofencesTask(context, loc));
        } else {
            loc = lm.getLastKnownLocation("network");
            if (loc != null && System.currentTimeMillis() - loc.getTime() < 60000L && loc.getAccuracy() < 50.0f) {
                SLog.d(TAG, "Using cached Network location: " + loc.getAccuracy(), new Object[0]);
                intent.putExtra("location", (Parcelable)loc);
                context.startService(intent);
            } else {
                Criteria crit = new Criteria();
                String provider = lm.getBestProvider(crit, true);
                if (provider != null) {
                    SLog.d(TAG, "Best provider is " + provider, new Object[0]);
                    PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)0, (Intent)intent, (int)0xA000000);
                    lm.requestSingleUpdate(crit, pendingIntent);
                } else {
                    SLog.w(TAG, "No location provider available.", new Object[0]);
                }
            }
        }
    }
}

