/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.loc;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.sas.mkt.mobile.sdk.InternalSingleton;
import com.sas.mkt.mobile.sdk.JsonHandler;
import com.sas.mkt.mobile.sdk.SASCollectorBroadcastReceiver;
import com.sas.mkt.mobile.sdk.domain.AppEnvironment;
import com.sas.mkt.mobile.sdk.domain.SimpleBeacon;
import com.sas.mkt.mobile.sdk.domain.SimpleGeofence;
import com.sas.mkt.mobile.sdk.util.SLog;
import com.sas.mkt.mobile.sdk.util.SecureStorage;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class GeofenceManager {
    public static final String TAG = GeofenceManager.class.getSimpleName();
    private SimpleGeofence[] cachedFences = new SimpleGeofence[0];
    private JsonHandler jsonHandler = new JsonHandler();

    public List<SimpleBeacon> getBeaconsForGeofence(Context context, String geofenceId) {
        SimpleGeofence[] persistedFences;
        String persistedFencesStr;
        ArrayList<SimpleBeacon> result = new ArrayList<SimpleBeacon>();
        if (this.cachedFences.length == 0 && (persistedFencesStr = SecureStorage.getInstance().readSimple(context, "geofences.enc", null)) != null && (persistedFences = (SimpleGeofence[])this.jsonHandler.fromJson(persistedFencesStr, (Type)((Object)SimpleGeofence[].class))) != null) {
            this.cachedFences = persistedFences;
        }
        for (SimpleGeofence fence : this.cachedFences) {
            if (fence.getBeacons() == null || !fence.getId().equals(geofenceId)) continue;
            result.addAll(fence.getBeacons());
        }
        return result;
    }

    public void restoreGeofences(Context context) {
        SimpleGeofence[] persistedFences;
        String persistedFencesStr = SecureStorage.getInstance().readSimple(context, "geofences.enc", null);
        if (persistedFencesStr != null && (persistedFences = (SimpleGeofence[])this.jsonHandler.fromJson(persistedFencesStr, (Type)((Object)SimpleGeofence[].class))) != null) {
            this.setGeofences(context, persistedFences);
        }
    }

    public void clearGeofences(Context context) {
        this.setGeofences(context, new SimpleGeofence[0]);
    }

    public void setGeofences(final Context context, final SimpleGeofence[] fences) {
        SimpleGeofence[] persistedFences;
        String persistedFencesStr;
        AppEnvironment appEnvironment = InternalSingleton.get().getAppEnvironment();
        if (appEnvironment == null || !appEnvironment.hasPlayServices()) {
            SLog.i(TAG, "Play services not available, unable to set geofences", new Object[0]);
            return;
        }
        if (this.cachedFences.length == 0 && (persistedFencesStr = SecureStorage.getInstance().readSimple(context, "geofences.enc", null)) != null && (persistedFences = (SimpleGeofence[])this.jsonHandler.fromJson(persistedFencesStr, (Type)((Object)SimpleGeofence[].class))) != null) {
            SLog.d(TAG, "Read " + persistedFences.length + " fences from persistence.", new Object[0]);
            this.cachedFences = persistedFences;
        }
        if (this.cachedFences.length > 0) {
            ArrayList<String> ids = new ArrayList<String>();
            for (SimpleGeofence f : this.cachedFences) {
                ids.add(f.getId());
            }
            SLog.d(TAG, "Removing " + ids.size() + " existing fences.", new Object[0]);
            Task result = LocationServices.getGeofencingClient((Context)context).removeGeofences(ids);
            result.addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

                public void onComplete(@NonNull Task<Void> task) {
                    if (task.isSuccessful()) {
                        GeofenceManager.access$002(GeofenceManager.this, new SimpleGeofence[0]);
                        if (fences != null && fences.length > 0) {
                            GeofenceManager.this.applyNewGeofences(context, fences);
                            GeofenceManager.access$002(GeofenceManager.this, fences);
                            String serializedGeofences = GeofenceManager.this.jsonHandler.toJson(GeofenceManager.this.cachedFences);
                            SecureStorage.getInstance().writeSimple(context, "geofences.enc", serializedGeofences);
                        } else {
                            SecureStorage.getInstance().removeSimple(context, "geofences.enc");
                            SLog.d(TAG, "List of new fences is empty.", new Object[0]);
                        }
                    } else {
                        if (task.getException() != null) {
                            SLog.e(TAG, (CharSequence)("Error clearing fences: (" + task.getException().getClass().getSimpleName() + ") " + task.getException().getMessage()), new Object[0]);
                            return;
                        }
                        SLog.e(TAG, (CharSequence)"Error clearing fences.", new Object[0]);
                    }
                }
            });
        } else {
            SLog.d(TAG, "No existing fences to remove.", new Object[0]);
            this.cachedFences = new SimpleGeofence[0];
            if (fences != null && fences.length > 0) {
                this.applyNewGeofences(context, fences);
                this.cachedFences = fences;
                String serializedGeofences = this.jsonHandler.toJson(this.cachedFences);
                SecureStorage.getInstance().writeSimple(context, "geofences.enc", serializedGeofences);
            } else {
                SecureStorage.getInstance().removeSimple(context, "geofences.enc");
                SLog.d(TAG, "List of new fences is empty.", new Object[0]);
            }
        }
    }

    private void applyNewGeofences(Context context, SimpleGeofence[] fences) {
        SLog.d(TAG, "Registering " + fences.length + " regions.", new Object[0]);
        GeofencingRequest.Builder geofencingRequestBuilder = new GeofencingRequest.Builder();
        Integer responsiveness = InternalSingleton.get().getIntegerConfigurationOption("geofence.responsiveness", null);
        for (SimpleGeofence fence : fences) {
            geofencingRequestBuilder.addGeofence(this.simpleGeofenceToGeofence(fence, responsiveness));
        }
        geofencingRequestBuilder.setInitialTrigger(1);
        Intent intent = new Intent(context, SASCollectorBroadcastReceiver.class);
        intent.setAction(SASCollectorBroadcastReceiver.ACTION_GEOFENCE_TRANSITION);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0xA000000);
        Task result = LocationServices.getGeofencingClient((Context)context).addGeofences(geofencingRequestBuilder.build(), pendingIntent);
        result.addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

            public void onComplete(@NonNull Task<Void> task) {
                if (!task.isSuccessful()) {
                    if (task.getException() != null) {
                        SLog.e(TAG, (CharSequence)("Error adding geofences: (" + task.getException().getClass().getSimpleName() + ") " + task.getException().getMessage()), new Object[0]);
                    } else {
                        SLog.e(TAG, (CharSequence)"Error adding geofences.", new Object[0]);
                    }
                } else {
                    SLog.d(TAG, "Geofence registration complete.", new Object[0]);
                }
            }
        });
    }

    private Geofence simpleGeofenceToGeofence(SimpleGeofence sg, Integer responsiveness) {
        Geofence.Builder builder = new Geofence.Builder();
        builder.setRequestId(sg.getId()).setTransitionTypes(3).setCircularRegion(sg.getLatitude(), sg.getLongitude(), sg.getRadius()).setExpirationDuration(-1L);
        if (responsiveness != null) {
            builder.setNotificationResponsiveness(responsiveness.intValue());
        }
        return builder.build();
    }

    static /* synthetic */ SimpleGeofence[] access$002(GeofenceManager x0, SimpleGeofence[] x1) {
        x0.cachedFences = x1;
        return x1;
    }
}

