/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.iam;

import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import com.sas.mkt.mobile.sdk.JsonHandler;
import com.sas.mkt.mobile.sdk.domain.PushData;
import com.sas.mkt.mobile.sdk.iam.BaseRootView;
import com.sas.mkt.mobile.sdk.iam.InAppFragmentInterface;
import com.sas.mkt.mobile.sdk.iam.ShadeView;
import com.sas.mkt.mobile.sdk.iam.SmallIAMRootView;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.lang.reflect.Type;

public class SmallMessageFragmentX
extends Fragment
implements BaseRootView.InAppActionListener,
InAppFragmentInterface {
    private static final String TAG = SmallMessageFragmentX.class.getSimpleName();
    public static final Object TAG_SHADE = SmallMessageFragmentX.class.getName() + ".TAG_SHADE";
    public static final String ARG_PUSH_DATA = "push_data";
    public static final String ARG_BMP_PARCEL = "bmp_parcel";
    private PushData pushData;
    private SmallIAMRootView root;
    private BaseRootView.InAppActionListener inAppActionListener;
    private boolean removeInProgress = false;
    private int commitId;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        JsonHandler json = new JsonHandler();
        ShadeView shade = new ShadeView(this.getContext());
        shade.setTag(TAG_SHADE);
        shade.setClickable(true);
        shade.setFocusable(true);
        shade.setFocusableInTouchMode(true);
        shade.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        String pushDataJson = this.getArguments().getString(ARG_PUSH_DATA);
        this.pushData = (PushData)json.fromJson(pushDataJson, (Type)((Object)PushData.class));
        String graphicFileName = this.getArguments().getString(ARG_BMP_PARCEL);
        if (Build.VERSION.SDK_INT >= 23) {
            this.root = new SmallIAMRootView(this.getContext(), this.pushData, graphicFileName);
            this.root.setInAppActionListener(this);
        } else {
            Log.w((String)SmallMessageFragmentX.class.getSimpleName(), (String)("Unable to create IAM, unexpected platform version " + Build.VERSION.SDK_INT));
        }
        shade.addView((View)this.root);
        shade.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                SLog.d(TAG, "Shade touch!", new Object[0]);
                if (event.getAction() == 1) {
                    SmallMessageFragmentX.this.dismissInAppFragment();
                }
                return false;
            }
        });
        return shade;
    }

    @Override
    public void setInAppActionListener(BaseRootView.InAppActionListener inAppActionListener) {
        this.inAppActionListener = inAppActionListener;
    }

    @Override
    public void onInAppMessageAction(BaseRootView baseRootView, String event, String link) {
        if (this.inAppActionListener != null) {
            this.inAppActionListener.onInAppMessageAction(baseRootView, event, link);
        }
        this.removeFragment();
    }

    @Override
    public void onInAppMessageDismiss() {
        if (this.inAppActionListener != null) {
            this.inAppActionListener.onInAppMessageDismiss();
        }
        this.removeFragment();
    }

    @Override
    public void showInAppFragment(FragmentManager fragmentManager) {
        this.commitId = fragmentManager.beginTransaction().add(0x1020002, (Fragment)this, "sas.mobile.message.tag").addToBackStack("In-App Message").commit();
    }

    @Override
    public void dismissInAppFragment() {
        if (this.inAppActionListener != null) {
            this.inAppActionListener.onInAppMessageDismiss();
        }
        this.removeFragment();
    }

    public void onDetach() {
        if (!this.removeInProgress && this.inAppActionListener != null) {
            this.inAppActionListener.onInAppMessageDismiss();
        }
        super.onDetach();
    }

    private void removeFragment() {
        this.removeInProgress = true;
        Fragment fragment = this.getFragmentManager().findFragmentByTag("sas.mobile.message.tag");
        if (fragment != null) {
            SLog.d(TAG, "Removing fragment.", new Object[0]);
            this.getFragmentManager().beginTransaction().remove(fragment).commit();
            this.getFragmentManager().popBackStackImmediate(this.commitId, 1);
        } else {
            SLog.w(TAG, "Fragment not found.", new Object[0]);
        }
        this.removeInProgress = false;
    }
}

