/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.iam;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.sas.mkt.mobile.sdk.domain.PushData;
import com.sas.mkt.mobile.sdk.iam.BaseRootView;
import com.sas.mkt.mobile.sdk.util.ImageHandler;
import com.sas.mkt.mobile.sdk.util.SLog;

public class SmallIAMRootView
extends BaseRootView {
    private static final String TAG = SmallIAMRootView.class.getSimpleName();
    public static final Object TAG_ROOT_LAYOUT = SmallIAMRootView.class.getName() + ".TAG_ROOT_LAYOUT";
    public static final Object TAG_BODY = SmallIAMRootView.class.getName() + ".TAG_BODY";
    public static final Object TAG_GRAPHIC = SmallIAMRootView.class.getName() + ".TAG_GRAPHIC";
    public static final Object TAG_CLOSE_BTN = SmallIAMRootView.class.getName() + ".TAG_CLOSE_BTN";
    private PushData pushData;
    private String link;
    private String event;
    private boolean shouldAnimate = true;
    private ImageView imgGraphic;
    private TextView txtBody;
    private RelativeLayout content;
    private RelativeLayout graphLayout;

    public SmallIAMRootView(Context context, PushData pushData, String graphicFileName) {
        super(context, pushData, graphicFileName);
        int relativeID;
        this.pushData = pushData;
        if (pushData.actions != null && pushData.actions.length > 0) {
            this.link = pushData.actions[0].link;
            this.event = pushData.actions[0].event;
        }
        int textColor = Color.parseColor((String)"#4e4e4e");
        int textSize = 12;
        int textTypeFace = 0;
        int backgroundColor = Color.parseColor((String)"#efefef");
        boolean backgroundBorder = false;
        int backgroundBorderColor = 0;
        try {
            if (pushData.content.bodyFont != null) {
                if (pushData.content.bodyFont.color != null) {
                    textColor = Color.parseColor((String)pushData.content.bodyFont.color);
                }
                textSize = pushData.content.bodyFont.size;
                if (pushData.content.bodyFont.style.equals("normal")) {
                    textTypeFace = 0;
                } else if (pushData.content.bodyFont.style.equals("bold")) {
                    textTypeFace = 1;
                } else if (pushData.content.bodyFont.style.equals("italic")) {
                    textTypeFace = 2;
                }
            }
            if (pushData.content.background != null) {
                backgroundColor = Color.parseColor((String)pushData.content.background.color);
                backgroundBorder = pushData.content.background.border;
                backgroundBorderColor = Color.parseColor((String)pushData.content.background.borderColor);
            }
        }
        catch (Exception e) {
            SLog.w(TAG, "Error parsing push data: " + e.getMessage(), new Object[0]);
        }
        RelativeLayout.LayoutParams rootLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
        rootLayoutParams.addRule(14);
        rootLayoutParams.addRule(12);
        this.setLayoutParams((ViewGroup.LayoutParams)rootLayoutParams);
        this.content = new RelativeLayout(this.getContext());
        LinearLayout.LayoutParams contentParams = new LinearLayout.LayoutParams(ImageHandler.pixelsToDip(context, 360), ImageHandler.pixelsToDip(context, 76));
        this.content.setLayoutParams((ViewGroup.LayoutParams)contentParams);
        ShapeDrawable backgroundDrawable = new ShapeDrawable();
        backgroundDrawable.setShape((Shape)new RectShape());
        backgroundDrawable.getPaint().setColor(backgroundColor);
        if (backgroundBorder) {
            ShapeDrawable outlineDrawable = null;
            outlineDrawable = new ShapeDrawable();
            outlineDrawable.setShape((Shape)new RectShape());
            outlineDrawable.getPaint().setColor(backgroundBorderColor);
            outlineDrawable.getPaint().setStrokeWidth(4.0f);
            outlineDrawable.getPaint().setStyle(Paint.Style.STROKE);
            LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{backgroundDrawable, outlineDrawable});
            this.content.setPadding(3, 3, 3, 3);
            this.content.setBackground((Drawable)layerDrawable);
        } else {
            this.content.setBackground((Drawable)backgroundDrawable);
        }
        this.content.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SmallIAMRootView.this.action();
            }
        });
        this.imgGraphic = new ImageView(this.getContext());
        this.imgGraphic.setId(SmallIAMRootView.generateViewId());
        this.imgGraphic.setTag(TAG_GRAPHIC);
        this.imgGraphic.setBackgroundColor(backgroundColor);
        RelativeLayout.LayoutParams imgParams = new RelativeLayout.LayoutParams(ImageHandler.pixelsToDip(context, 85), ImageHandler.pixelsToDip(context, 76));
        imgParams.addRule(9);
        imgParams.addRule(10);
        this.imgGraphic.setLayoutParams((ViewGroup.LayoutParams)imgParams);
        this.imgGraphic.setPadding(0, 0, 0, 0);
        this.imgGraphic.setScaleType(ImageView.ScaleType.FIT_CENTER);
        Bitmap scaled = ImageHandler.loadAndScaleImage(this.getContext(), graphicFileName, 85, 76);
        if (scaled != null) {
            this.imgGraphic.setImageBitmap(scaled);
        }
        if (pushData.content.graphicBorder != null && pushData.content.graphicBorder.border) {
            this.imgGraphic.setCropToPadding(true);
            ShapeDrawable drawable = new ShapeDrawable();
            drawable.setShape((Shape)new RectShape());
            if (pushData.content.graphicBorder.borderColor != null) {
                try {
                    drawable.getPaint().setColor(Color.parseColor((String)pushData.content.graphicBorder.borderColor));
                }
                catch (Exception e) {
                    SLog.w(TAG, "Error parsing graphic border color: " + e.getMessage(), new Object[0]);
                }
            }
            drawable.getPaint().setStrokeWidth(4.0f);
            drawable.getPaint().setStyle(Paint.Style.STROKE);
            drawable.setPadding(3, 3, 3, 3);
            this.graphLayout = new RelativeLayout(this.getContext());
            RelativeLayout.LayoutParams graphParams = new RelativeLayout.LayoutParams(ImageHandler.pixelsToDip(context, 85), ImageHandler.pixelsToDip(context, 76));
            graphParams.addRule(9);
            graphParams.addRule(10);
            this.graphLayout.setLayoutParams((ViewGroup.LayoutParams)graphParams);
            this.graphLayout.setId(SmallIAMRootView.generateViewId());
            this.graphLayout.addView((View)this.imgGraphic);
            this.graphLayout.setBackground((Drawable)drawable);
        }
        if (this.graphLayout != null) {
            this.content.addView((View)this.graphLayout);
            relativeID = this.graphLayout.getId();
        } else {
            this.content.addView((View)this.imgGraphic);
            relativeID = this.imgGraphic.getId();
        }
        RelativeLayout textContainer = new RelativeLayout(this.getContext());
        RelativeLayout.LayoutParams textContainerParams = new RelativeLayout.LayoutParams(-2, -2);
        textContainerParams.addRule(1, relativeID);
        textContainerParams.addRule(15);
        textContainerParams.setMargins(20, 0, 20, 0);
        textContainer.setLayoutParams((ViewGroup.LayoutParams)textContainerParams);
        this.txtBody = new TextView(this.getContext());
        this.txtBody.setId(SmallIAMRootView.generateViewId());
        this.txtBody.setTag(TAG_BODY);
        String bodyText = pushData.content.body == null ? "" : pushData.content.body;
        this.txtBody.setText((CharSequence)bodyText);
        this.txtBody.setTextSize(2, (float)textSize);
        this.txtBody.setTypeface(this.txtBody.getTypeface(), textTypeFace);
        this.txtBody.setTextColor(textColor);
        this.txtBody.setGravity(0x800003);
        this.txtBody.setMaxLines(3);
        this.txtBody.setEllipsize(TextUtils.TruncateAt.END);
        RelativeLayout.LayoutParams txtBodyParams = new RelativeLayout.LayoutParams(-2, -2);
        txtBodyParams.addRule(9);
        txtBodyParams.addRule(10);
        this.txtBody.setLayoutParams((ViewGroup.LayoutParams)txtBodyParams);
        textContainer.addView((View)this.txtBody);
        this.content.addView((View)textContainer);
        TextView btnClose = new TextView(this.getContext());
        btnClose.setText((CharSequence)"\u00d7");
        btnClose.setTag(TAG_CLOSE_BTN);
        RelativeLayout.LayoutParams btnCloseParams = new RelativeLayout.LayoutParams(-2, -2);
        btnCloseParams.addRule(10);
        btnCloseParams.addRule(11);
        btnCloseParams.setMargins(0, 0, 20, 0);
        btnClose.setLayoutParams((ViewGroup.LayoutParams)btnCloseParams);
        btnClose.setBackgroundColor(0);
        btnClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SmallIAMRootView.this.inAppActionListener != null) {
                    SmallIAMRootView.this.inAppActionListener.onInAppMessageDismiss();
                }
            }
        });
        this.content.addView((View)btnClose);
        this.addView((View)this.content);
        this.setTag(TAG_ROOT_LAYOUT);
    }

    private void action() {
        if (this.inAppActionListener != null) {
            this.inAppActionListener.onInAppMessageAction(this, this.event, this.link);
        }
    }

    private void dismiss() {
        if (this.inAppActionListener != null) {
            this.inAppActionListener.onInAppMessageDismiss();
        }
    }
}

