/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.iam;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.TaskStackBuilder;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.sas.mkt.mobile.sdk.DeviceAndApplicationInfoHelper;
import com.sas.mkt.mobile.sdk.InternalSingleton;
import com.sas.mkt.mobile.sdk.SASCollector;
import com.sas.mkt.mobile.sdk.SASCollectorEvent;
import com.sas.mkt.mobile.sdk.SASCollectorIntentService;
import com.sas.mkt.mobile.sdk.domain.MobileEvent;
import com.sas.mkt.mobile.sdk.domain.PushData;
import com.sas.mkt.mobile.sdk.iam.BaseRootView;
import com.sas.mkt.mobile.sdk.iam.InAppFragmentInterface;
import com.sas.mkt.mobile.sdk.iam.LargeMessageFragmentX;
import com.sas.mkt.mobile.sdk.iam.NonFragmentWrapper;
import com.sas.mkt.mobile.sdk.iam.PendingIntentProvider;
import com.sas.mkt.mobile.sdk.iam.SASMobileMessagingDelegate2;
import com.sas.mkt.mobile.sdk.iam.SmallMessageFragmentX;
import com.sas.mkt.mobile.sdk.tasks.DownloadRemoteImageTask;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class MobileMessageHelper
implements DownloadRemoteImageTask.Callback,
BaseRootView.InAppActionListener {
    private static final String TAG = MobileMessageHelper.class.getSimpleName();
    private Integer currentIAMViewId = null;
    private PushData currentPushData = null;
    private String currentLocalGraphicFile = null;
    private AtomicReference<IAMState> iamState = new AtomicReference<IAMState>(IAMState.IDLE);

    public boolean handleInAppMessage(Context context, PushData pd, String rawPushData) {
        if (this.iamState.get() != IAMState.IDLE) {
            SLog.w(TAG, "Ignoring in-app message request, IAM state is " + (Object)((Object)this.iamState.get()), new Object[0]);
            return false;
        }
        Activity currentActivity = InternalSingleton.get().getCurrentActivity();
        if (currentActivity != null && pd.content != null && pd.content.graphic != null) {
            this.currentPushData = pd;
            this.iamState.set(IAMState.DOWNLOADING);
            InternalSingleton.get().getCommonExecutor().execute(new DownloadRemoteImageTask(this.currentPushData.content.graphic, this));
            return true;
        }
        SLog.i(TAG, "No current activity, unable to show mobile message", new Object[0]);
        return false;
    }

    public IAMState getIAMState() {
        return this.iamState.get();
    }

    public void handlePushNotification(Context context, final PushData pd, final Map<String, String> attrs) {
        Activity currentActivity = InternalSingleton.get().getCurrentActivity();
        if (currentActivity == null) {
            if (pd.content.graphic != null && pd.content.graphic.trim().length() > 0) {
                InternalSingleton.get().getCommonExecutor().execute(new DownloadRemoteImageTask(pd.content.graphic, new DownloadRemoteImageTask.Callback(){

                    @Override
                    public void downloadComplete(String filename) {
                        pd.content.graphic = filename;
                        String spotId = (String)attrs.get("spot_id");
                        MobileMessageHelper.this.showNotification((Context)InternalSingleton.get().getApplication(), pd, spotId);
                    }

                    @Override
                    public void downloadFailure(String message) {
                        SLog.e(TAG, (CharSequence)("Error during notification graphic download: " + message), new Object[0]);
                    }
                }));
            } else {
                String spotId = attrs.get("spot_id");
                this.showNotification(context, pd, spotId);
            }
            attrs.put("mobile_platform", DeviceAndApplicationInfoHelper.getDevicePlatform());
            InternalSingleton.get().addAppEventInternal(new SASCollectorEvent("spot_viewable", attrs), MobileEvent.SessionIndicator.NO_NEW_SESSION);
        } else {
            SLog.d(TAG, "Ignoring push notification, app is in focus.", new Object[0]);
        }
    }

    private void showNotification(Context context, PushData pd, String spotId) {
        ApplicationInfo info;
        if (context == null) {
            SLog.e(TAG, (CharSequence)"Null context passed to showNotification.", new Object[0]);
            return;
        }
        int notificationId = (int)System.currentTimeMillis();
        int iconResourceId = -1;
        int iconColor = -1;
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.sas.mkt.mobile.sdk.SASCollector", 0);
        try {
            info = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            iconResourceId = sharedPreferences.getInt("mobile.message.icon.resource", info.icon);
            iconColor = sharedPreferences.getInt("mobile.message.icon.color.resource", 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            SLog.e(TAG, (CharSequence)("Error loading application info: " + e.getMessage()), new Object[0]);
            return;
        }
        Notification.Builder builder = new Notification.Builder(context);
        Notification.BigTextStyle style = null;
        if (pd.content.graphic == null || pd.content.graphic.trim().length() == 0) {
            style = new Notification.BigTextStyle().bigText((CharSequence)pd.content.body);
            if (pd.content.title != null) {
                style = style.setBigContentTitle((CharSequence)pd.content.title);
            }
        } else {
            try {
                Bitmap bmp = BitmapFactory.decodeStream((InputStream)new FileInputStream(new File(pd.content.graphic)));
                if (bmp == null) {
                    SLog.e(TAG, (CharSequence)"Error loading notification graphic", new Object[0]);
                    return;
                }
                Bitmap largeIcon = null;
                style = new Notification.BigPictureStyle().bigPicture(bmp).bigLargeIcon(largeIcon).setSummaryText((CharSequence)pd.content.body);
                builder.setLargeIcon(bmp);
                if (pd.content.title != null) {
                    style = ((Notification.BigPictureStyle)style).setBigContentTitle((CharSequence)pd.content.title);
                }
            }
            catch (Exception e) {
                SLog.e(TAG, (CharSequence)("Error loading notification graphic: " + e.getClass().getSimpleName() + " " + e.getMessage()), new Object[0]);
                return;
            }
        }
        builder.setStyle((Notification.Style)style);
        builder.setSmallIcon(iconResourceId);
        if (pd.content.title != null) {
            builder.setContentTitle((CharSequence)pd.content.title);
        } else {
            builder.setContentTitle(context.getPackageManager().getApplicationLabel(info));
        }
        builder.setContentText((CharSequence)pd.content.body);
        builder.setAutoCancel(true);
        builder.setShowWhen(true);
        if (Build.VERSION.SDK_INT >= 26 && iconColor != 0) {
            builder.setColor(iconColor);
        }
        Intent notificationIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
        notificationIntent.addFlags(0x400000);
        if (pd.actions != null && pd.actions.length != 0 && pd.actions[0].link != null && InternalSingleton.get().getMobileMessagingDelegate2() != null) {
            Intent tmp = InternalSingleton.get().getMobileMessagingDelegate2().getNotificationIntent(pd.actions[0].link);
            if (tmp != null) {
                notificationIntent = tmp;
            } else {
                SLog.i(TAG, "No Notification Intent provided by MobileMessagingDelegate, notification will open default launch Intent for app", new Object[0]);
            }
        }
        notificationIntent.putExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_ID, notificationId);
        notificationIntent.putExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_CREATIVE_ID, pd.creativeId);
        notificationIntent.putExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_TASK_ID, pd.taskId);
        notificationIntent.putExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_EVENT_ID, pd.eventId);
        notificationIntent.putExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_SPOT_ID, spotId);
        if (pd.actions != null && pd.actions.length > 0) {
            SLog.d(TAG, "Adding action: %s %s", pd.actions[0].event, pd.actions[0].link);
            notificationIntent.putExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_ACTION_EVENT_ID, pd.actions[0].event);
            notificationIntent.putExtra(SASCollectorIntentService.EXTRA_NOTIFICATION_ACTION_LINK, pd.actions[0].link);
        } else {
            SLog.w(TAG, "No actions in message.", new Object[0]);
        }
        Bundle extras = notificationIntent.getExtras();
        for (String key : extras.keySet()) {
            SLog.d(TAG, "Outbound Intent extra: %s=%s", key, notificationIntent.getExtras().get(key));
        }
        PendingIntent pendingNotificationIntent = TaskStackBuilder.create((Context)context).addNextIntent(notificationIntent).getPendingIntent(notificationId, 0x44000000);
        if (InternalSingleton.get().isAppRelaunchDisabledOnPushOpen()) {
            pendingNotificationIntent = new PendingIntentProvider().getPendingIntent(context, notificationIntent);
        }
        builder.setContentIntent(pendingNotificationIntent);
        this.checkForNotificationChannel(context, builder);
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.notify(notificationId, builder.build());
    }

    private void checkForNotificationChannel(Context context, Notification.Builder builder) {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationManager notificationManager;
            NotificationChannel channel;
            SharedPreferences sharedPreferences = context.getSharedPreferences("com.sas.mkt.mobile.sdk.SASCollector", 0);
            String channelId = sharedPreferences.getString("push.notification.channel.id", null);
            try {
                Method m = builder.getClass().getMethod("setChannelId", String.class);
                if (m == null) {
                    throw new Exception("No setChannelId method found.");
                }
            }
            catch (Exception e) {
                SLog.w(TAG, "Error accessing notification channel API, support-v4 library dependency may need update.", new Object[0]);
                return;
            }
            if (channelId == null) {
                SLog.d(TAG, "Using default notification channel.", new Object[0]);
                channelId = "miscellaneous";
            }
            if ((channel = (notificationManager = (NotificationManager)context.getSystemService("notification")).getNotificationChannel(channelId)) == null) {
                SLog.e(TAG, (CharSequence)"Notification channel %s not found", channelId);
                return;
            }
            if (channel.getImportance() == 0) {
                SLog.w(TAG, "Notification channel is blocked.", new Object[0]);
                return;
            }
            builder.setChannelId(channelId);
        } else {
            SLog.i(TAG, "Pre-8.0 Android level, skipping notification channel.", new Object[0]);
        }
    }

    private void renderInAppMessage() {
        block15: {
            SLog.d(TAG, "Rendering in-app message.", new Object[0]);
            Activity currentActivity = InternalSingleton.get().getCurrentActivity();
            if (currentActivity != null) {
                if (this.isJetpackActivity(currentActivity)) {
                    FragmentActivity fragmentActivity = (FragmentActivity)currentActivity;
                    Fragment fragment = fragmentActivity.getSupportFragmentManager().findFragmentByTag("sas.mobile.message.tag");
                    if (fragment == null) {
                        SLog.d(TAG, "Adding new fragment for in-app message.", new Object[0]);
                        BaseRootView.InAppActionListener inAppFragmentInterface = null;
                        if ("creative.mobileInAppMessage.large".equals(this.currentPushData.template)) {
                            inAppFragmentInterface = new LargeMessageFragmentX();
                        } else if ("creative.mobileInAppMessage.small".equals(this.currentPushData.template)) {
                            inAppFragmentInterface = new SmallMessageFragmentX();
                        } else {
                            SLog.e(TAG, (CharSequence)("Unexpected in-app message template: " + this.currentPushData.template), new Object[0]);
                            this.iamState.set(IAMState.IDLE);
                            return;
                        }
                        inAppFragmentInterface.setInAppActionListener(this);
                        Bundle args = new Bundle();
                        args.putString("push_data", InternalSingleton.get().getJsonHandler().toJson(this.currentPushData));
                        args.putString("bmp_parcel", this.currentLocalGraphicFile);
                        inAppFragmentInterface.setArguments(args);
                        inAppFragmentInterface.showInAppFragment(fragmentActivity.getSupportFragmentManager());
                        this.iamState.set(IAMState.SHOW);
                    } else {
                        SLog.d(TAG, "Fragment already rendered: " + fragment.getClass().getName(), new Object[0]);
                        if (fragment instanceof InAppFragmentInterface) {
                            ((InAppFragmentInterface)fragment).setInAppActionListener(this);
                            this.iamState.set(IAMState.SHOW);
                        } else {
                            SLog.e(TAG, (CharSequence)("Unexpected fragment class: " + fragment.getClass().getName()), new Object[0]);
                            this.iamState.set(IAMState.IDLE);
                        }
                    }
                } else {
                    try {
                        NonFragmentWrapper shadeView;
                        NonFragmentWrapper nonFragmentWrapper = shadeView = this.currentIAMViewId == null ? null : (NonFragmentWrapper)currentActivity.findViewById(this.currentIAMViewId.intValue());
                        if (shadeView == null) {
                            SLog.d(TAG, "Rendering new non-fragment in-app.", new Object[0]);
                            shadeView = new NonFragmentWrapper(currentActivity, this.currentPushData, this.currentLocalGraphicFile);
                            this.currentIAMViewId = shadeView.getId();
                            shadeView.setInAppActionListener(this);
                            ViewGroup.LayoutParams shadeViewParams = new ViewGroup.LayoutParams(-1, -1);
                            currentActivity.addContentView((View)shadeView, shadeViewParams);
                            shadeView.requestFocus();
                            this.iamState.set(IAMState.SHOW);
                            break block15;
                        }
                        SLog.d(TAG, "Non-fragment in-app already rendered: " + this.currentIAMViewId, new Object[0]);
                        this.iamState.set(IAMState.SHOW);
                    }
                    catch (Exception e) {
                        SLog.w(TAG, "Failed to render IAM: " + e.getMessage(), new Object[0]);
                        this.iamState.set(IAMState.IDLE);
                    }
                }
            } else {
                SLog.w(TAG, "Current Activity is no longer valid, unable to render IAM", new Object[0]);
                this.iamState.set(IAMState.IDLE);
            }
        }
    }

    private boolean isJetpackActivity(Activity activity) {
        return InternalSingleton.get().getAppEnvironment().hasJetpackFragments() && activity instanceof FragmentActivity;
    }

    @Override
    public void downloadComplete(String filename) {
        this.currentLocalGraphicFile = filename;
        InternalSingleton.get().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (MobileMessageHelper.this.currentPushData == null) {
                        SLog.w(TAG, "In-app data no longer valid, unable to render.", new Object[0]);
                        return;
                    }
                    MobileMessageHelper.this.renderInAppMessage();
                }
                catch (Exception e) {
                    SLog.e(TAG, (CharSequence)("Error rending in-app in UI thread: " + e.getMessage()), new Object[0]);
                }
            }
        });
        SASCollector.getInstance().addAppEvent("spot_viewable", this.getEventData());
    }

    @Override
    public void downloadFailure(String message) {
        this.iamState.set(IAMState.IDLE);
    }

    public Map<String, String> getEventData() {
        HashMap<String, String> data = new HashMap<String, String>();
        if (this.currentPushData != null) {
            data.put("creative_id", this.currentPushData.creativeId);
            data.put("task_id", this.currentPushData.taskId);
            data.put("spot_id", String.format("%s_%s", SASCollector.getInstance().getApplicationID(), this.currentPushData.template));
            data.put("event_id", this.currentPushData.eventId);
        } else {
            SLog.e(TAG, (CharSequence)"Unable to gather event data, current PushData not available.", new Object[0]);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInAppMessageAction(BaseRootView baseRootView, String event, String link) {
        SLog.d(TAG, "In-app message action: " + event + " " + link, new Object[0]);
        try {
            Map<String, String> data = this.getEventData();
            data.put("uri", link);
            SASCollector.getInstance().addAppEvent(event, data);
            if (SASCollector.getInstance().getMobileMessagingDelegate2() != null) {
                SASCollector.getInstance().getMobileMessagingDelegate2().action(link, SASMobileMessagingDelegate2.SASMobileMessageType.IN_APP_MESSAGE);
            }
        }
        finally {
            this.currentPushData = null;
            this.currentLocalGraphicFile = null;
            this.currentIAMViewId = null;
            this.iamState.set(IAMState.IDLE);
        }
    }

    @Override
    public void onInAppMessageDismiss() {
        SLog.d(TAG, "In-app message dismissed.", new Object[0]);
        try {
            if (this.currentPushData != null) {
                if (SASCollector.getInstance().getMobileMessagingDelegate2() != null) {
                    SASCollector.getInstance().getMobileMessagingDelegate2().dismissed();
                }
                Map<String, String> data = this.getEventData();
                SASCollector.getInstance().addAppEvent(this.currentPushData.dismissEvent, data);
            } else {
                SLog.e(TAG, (CharSequence)"Unexpected in-app message dismiss, no current push data.", new Object[0]);
            }
        }
        finally {
            this.currentPushData = null;
            this.currentLocalGraphicFile = null;
            this.currentIAMViewId = null;
            this.iamState.set(IAMState.IDLE);
        }
    }

    private void removeCurrentInAppMessage() {
        SLog.d(TAG, "Removing current in-app message.", new Object[0]);
        Activity currentActivity = InternalSingleton.get().getCurrentActivity();
        if (currentActivity != null) {
            if (this.isJetpackActivity(currentActivity)) {
                FragmentActivity fragmentActivity = (FragmentActivity)currentActivity;
                Fragment fragment = fragmentActivity.getSupportFragmentManager().findFragmentByTag("sas.mobile.message.tag");
                if (fragment instanceof InAppFragmentInterface) {
                    ((InAppFragmentInterface)fragment).dismissInAppFragment();
                }
            } else if (this.currentIAMViewId != null) {
                NonFragmentWrapper currentShadeView = (NonFragmentWrapper)currentActivity.findViewById(this.currentIAMViewId.intValue());
                if (currentShadeView != null) {
                    currentShadeView.dismissInApp();
                } else {
                    SLog.e(TAG, (CharSequence)("No current in-app found by ID " + this.currentIAMViewId), new Object[0]);
                }
            } else {
                SLog.d(TAG, "No in-app active.", new Object[0]);
            }
        } else {
            SLog.w(TAG, "No current activity, unable to remove current in-app message.", new Object[0]);
        }
    }

    public void notifyActivityResume(Activity activity) {
        if (this.iamState.get() == IAMState.SHOW && this.currentPushData != null) {
            this.renderInAppMessage();
        }
    }

    public void notifyActivityPaused(Activity activity) {
        if (!activity.isChangingConfigurations()) {
            if (Boolean.parseBoolean(InternalSingleton.get().getConfigurationOption("dismiss.in-app.on.activity.pause", Boolean.FALSE.toString()))) {
                this.removeCurrentInAppMessage();
            }
        } else {
            SLog.d(TAG, "Configuration change.", new Object[0]);
        }
    }

    public static enum IAMState {
        IDLE,
        DOWNLOADING,
        SHOW;

    }
}

