/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.iam;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.sas.mkt.mobile.sdk.domain.PushData;
import com.sas.mkt.mobile.sdk.iam.BaseRootView;
import com.sas.mkt.mobile.sdk.util.ImageHandler;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.util.ArrayList;

public class LargeIAMRootView
extends BaseRootView {
    private static final String TAG = LargeIAMRootView.class.getSimpleName();
    public static final Object TAG_ROOT_LAYOUT = LargeIAMRootView.class.getName() + ".TAG_ROOT_LAYOUT";
    public static final Object TAG_TITLE = LargeIAMRootView.class.getName() + ".TAG_TITLE";
    public static final Object TAG_BODY = LargeIAMRootView.class.getName() + ".TAG_BODY";
    public static final Object TAG_GRAPHIC = LargeIAMRootView.class.getName() + ".TAG_GRAPHIC";
    public static final Object[] TAG_BUTTON = new Object[]{LargeIAMRootView.class.getName() + ".TAG_BUTTON_1", LargeIAMRootView.class.getName() + ".TAG_BUTTON_2", LargeIAMRootView.class.getName() + ".TAG_BUTTON_3"};
    private static final int VERTICAL_PADDING = 12;
    private static final int BUTTON_CHAR_MAX = 18;
    private ImageView imgGraphic;
    private TextView txtTitle;
    private TextView txtBody;
    private LinearLayout graphLayout;
    private LinearLayout textLayout;
    private LinearLayout buttonLayout;

    public LargeIAMRootView(Context context, PushData pushData, String graphicFileName) {
        super(context, pushData, graphicFileName);
        LinearLayout.LayoutParams imgParams;
        Bitmap scaled;
        int textColor = Color.parseColor((String)"#4e4e4e");
        int bodyColor = Color.parseColor((String)"#4e4e4e");
        int backgroundColor = Color.parseColor((String)"#efefef");
        boolean backgroundBorder = false;
        int backgroundBorderColor = 0;
        try {
            if (pushData.content.titleFont != null) {
                textColor = Color.parseColor((String)pushData.content.titleFont.color);
            }
            if (pushData.content.bodyFont != null) {
                bodyColor = Color.parseColor((String)pushData.content.bodyFont.color);
            }
            if (pushData.content.background != null) {
                backgroundColor = Color.parseColor((String)pushData.content.background.color);
                backgroundBorder = pushData.content.background.border;
                backgroundBorderColor = Color.parseColor((String)pushData.content.background.borderColor);
            }
        }
        catch (Exception e) {
            SLog.w(TAG, "Unable to parse color specification: " + e.getMessage(), new Object[0]);
        }
        ShapeDrawable backgroundDrawable = new ShapeDrawable();
        backgroundDrawable.setShape((Shape)new RectShape());
        backgroundDrawable.getPaint().setColor(backgroundColor);
        if (backgroundBorder) {
            ShapeDrawable outlineDrawable = null;
            outlineDrawable = new ShapeDrawable();
            outlineDrawable.setShape((Shape)new RectShape());
            outlineDrawable.getPaint().setColor(backgroundBorderColor);
            outlineDrawable.getPaint().setStrokeWidth(4.0f);
            outlineDrawable.getPaint().setStyle(Paint.Style.STROKE);
            LayerDrawable drawable = new LayerDrawable(new Drawable[]{outlineDrawable, backgroundDrawable});
            this.setPadding(3, 3, 3, 3);
            this.setBackground((Drawable)drawable);
        } else {
            this.setBackground((Drawable)backgroundDrawable);
        }
        this.imgGraphic = new ImageView(this.getContext());
        this.imgGraphic.setTag(TAG_GRAPHIC);
        this.graphLayout = null;
        this.imgGraphic.setPadding(0, 0, 0, 0);
        this.imgGraphic.setScaleType(ImageView.ScaleType.FIT_CENTER);
        if (pushData.content.graphicBorder != null && pushData.content.graphicBorder.border) {
            this.imgGraphic.setCropToPadding(true);
            ShapeDrawable drawable = new ShapeDrawable();
            drawable.setShape((Shape)new RectShape());
            drawable.getPaint().setColor(Color.parseColor((String)pushData.content.graphicBorder.borderColor));
            drawable.getPaint().setStrokeWidth(4.0f);
            drawable.getPaint().setStyle(Paint.Style.STROKE);
            drawable.setPadding(3, 3, 3, 3);
            this.graphLayout = new LinearLayout(this.getContext());
            this.graphLayout.addView((View)this.imgGraphic);
            this.graphLayout.setBackground((Drawable)drawable);
        }
        if ((scaled = ImageHandler.loadAndScaleImage(context, graphicFileName, 320, 227)) != null) {
            this.imgGraphic.setImageBitmap(scaled);
        }
        this.txtTitle = new TextView(this.getContext());
        this.txtTitle.setTag(TAG_TITLE);
        this.txtTitle.setMaxLines(2);
        String titleText = pushData.content.title == null ? "" : pushData.content.title;
        this.txtTitle.setText((CharSequence)titleText);
        this.txtTitle.setTextSize(2, 16.0f);
        if (pushData.content.titleFont != null) {
            this.txtTitle.setTextSize(2, (float)pushData.content.titleFont.size);
            if ("normal".equals(pushData.content.titleFont.style)) {
                this.txtTitle.setTypeface(this.txtTitle.getTypeface(), 0);
            } else if ("bold".equals(pushData.content.titleFont.style)) {
                this.txtTitle.setTypeface(this.txtTitle.getTypeface(), 1);
            } else if ("italic".equals(pushData.content.titleFont.style)) {
                this.txtTitle.setTypeface(this.txtTitle.getTypeface(), 2);
            }
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.txtTitle.setLetterSpacing(0.1f);
        }
        this.txtTitle.setTextColor(textColor);
        this.txtTitle.setPadding(27, 12, 27, 12);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        this.txtTitle.setLayoutParams((ViewGroup.LayoutParams)params);
        this.txtTitle.setGravity(1);
        this.txtBody = new TextView(this.getContext());
        this.txtBody.setTag(TAG_BODY);
        int maxLines = pushData.actions == null ? 5 : Math.max(2, 5 - pushData.actions.length);
        this.txtBody.setMaxLines(maxLines);
        String bodyText = pushData.content.body == null ? "" : pushData.content.body;
        this.txtBody.setText((CharSequence)bodyText);
        this.txtBody.setTextSize(2, 12.0f);
        if (pushData.content.bodyFont != null) {
            this.txtBody.setTextSize(2, (float)pushData.content.bodyFont.size);
            if ("normal".equals(pushData.content.bodyFont.style)) {
                this.txtBody.setTypeface(this.txtBody.getTypeface(), 0);
            } else if ("bold".equals(pushData.content.bodyFont.style)) {
                this.txtBody.setTypeface(this.txtBody.getTypeface(), 1);
            } else if ("italic".equals(pushData.content.bodyFont.style)) {
                this.txtBody.setTypeface(this.txtBody.getTypeface(), 2);
            }
        }
        this.txtBody.setTextColor(bodyColor);
        this.txtBody.setGravity(1);
        this.txtBody.setPadding(27, 12, 27, 12);
        params = new LinearLayout.LayoutParams(-2, -2);
        this.txtBody.setLayoutParams((ViewGroup.LayoutParams)params);
        this.textLayout = new LinearLayout(this.getContext());
        this.textLayout.setGravity(1);
        this.textLayout.setOrientation(1);
        this.textLayout.setBackgroundColor(backgroundColor);
        this.textLayout.addView((View)this.txtTitle);
        this.textLayout.addView((View)this.txtBody);
        this.buttonLayout = new LinearLayout(this.getContext());
        this.buttonLayout.setOrientation(1);
        params = new LinearLayout.LayoutParams(-2, -2);
        this.buttonLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        this.buttonLayout.setGravity(1);
        int tagCount = 0;
        for (PushData.Action action : pushData.actions) {
            String label;
            int btnBackgroundColor = backgroundColor;
            Button btn = new Button(this.getContext());
            btn.setTag(TAG_BUTTON[tagCount++]);
            params = pushData.constrainWidths ? new LinearLayout.LayoutParams(-1, ImageHandler.pixelsToDip(context, 38)) : new LinearLayout.LayoutParams(-2, ImageHandler.pixelsToDip(context, 38));
            params.setMargins(0, 12, 0, 12);
            btn.setLayoutParams((ViewGroup.LayoutParams)params);
            btn.setPadding(ImageHandler.pixelsToDip(context, 5), 0, ImageHandler.pixelsToDip(context, 5), 0);
            String string = label = action.label == null ? "" : action.label;
            if (label.length() > 18) {
                label = label.substring(0, 18);
            }
            btn.setText((CharSequence)label);
            btn.setTextSize(2, 12.0f);
            btn.setTypeface(Typeface.DEFAULT);
            boolean hasOutline = true;
            if (action.font != null) {
                btn.setTextSize(2, (float)action.font.size);
                if ("normal".equals(action.font.style)) {
                    btn.setTypeface(btn.getTypeface(), 0);
                } else if ("bold".equals(action.font.style)) {
                    btn.setTypeface(btn.getTypeface(), 1);
                } else if ("italic".equals(action.font.style)) {
                    btn.setTypeface(btn.getTypeface(), 2);
                }
            }
            if (action.background != null) {
                hasOutline = action.background.border;
                if (action.background.color != null) {
                    btnBackgroundColor = Color.parseColor((String)action.background.color);
                }
            }
            btn.setMinWidth(90);
            btn.setTextColor(textColor);
            if (action.font != null && action.font.color != null) {
                btn.setTextColor(Color.parseColor((String)action.font.color));
            }
            btn.setBackgroundColor(btnBackgroundColor);
            btn.setGravity(17);
            btn.setAllCaps(false);
            if (Build.VERSION.SDK_INT >= 21) {
                btn.setStateListAnimator(null);
            }
            int radius = 0;
            if (action.cornerRadius > 0) {
                radius = ImageHandler.pixelsToDip(context, action.cornerRadius);
            }
            float[] radii = new float[]{radius, radius, radius, radius, radius, radius, radius, radius};
            ShapeDrawable outlineDrawable = null;
            if (hasOutline) {
                outlineDrawable = new ShapeDrawable();
                outlineDrawable.setShape((Shape)new RectShape());
                if (action.cornerRadius > 0) {
                    outlineDrawable.setShape((Shape)new RoundRectShape(radii, null, null));
                }
                outlineDrawable.getPaint().setColor(-16777216);
                if (action.background != null && action.background.borderColor != null) {
                    outlineDrawable.getPaint().setColor(Color.parseColor((String)action.background.borderColor));
                }
                outlineDrawable.getPaint().setStrokeWidth(4.0f);
                outlineDrawable.getPaint().setStyle(Paint.Style.STROKE);
            }
            ShapeDrawable btnBackgroundDrawable = null;
            if (action.background != null && action.background.color != null) {
                btnBackgroundDrawable = new ShapeDrawable();
                btnBackgroundDrawable.setShape((Shape)new RectShape());
                if (action.cornerRadius > 0) {
                    btnBackgroundDrawable.setShape((Shape)new RoundRectShape(radii, null, null));
                }
                btnBackgroundDrawable.getPaint().setColor(Color.parseColor((String)action.background.color));
            }
            if (Build.VERSION.SDK_INT >= 16 && (outlineDrawable != null || btnBackgroundDrawable != null)) {
                ArrayList<ShapeDrawable> layers = new ArrayList<ShapeDrawable>();
                int index = 0;
                if (outlineDrawable != null) {
                    ++index;
                    layers.add(outlineDrawable);
                }
                if (backgroundDrawable != null) {
                    layers.add(btnBackgroundDrawable);
                }
                LayerDrawable drawable = new LayerDrawable(layers.toArray(new Drawable[0]));
                if (btnBackgroundDrawable != null) {
                    drawable.setLayerInset(index, 3, 3, 3, 3);
                }
                if (outlineDrawable != null) {
                    drawable.setLayerInset(0, 2, 2, 2, 2);
                }
                btn.setBackground((Drawable)drawable);
            }
            btn.setOnClickListener((View.OnClickListener)new ActionButtonListener(action));
            this.buttonLayout.addView((View)btn);
        }
        this.textLayout.addView((View)this.buttonLayout);
        Resources resources = context.getResources();
        Configuration configuration = resources.getConfiguration();
        int orientation = configuration.orientation;
        if (orientation == 1) {
            params = new LinearLayout.LayoutParams(ImageHandler.pixelsToDip(context, 320), -1);
            params.weight = 1.0f;
        } else {
            params = new LinearLayout.LayoutParams(ImageHandler.pixelsToDip(context, 245), -2);
        }
        this.textLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        this.setOrientation(orientation == 2 ? 0 : 1);
        if (this.graphLayout == null) {
            this.addView((View)this.imgGraphic);
        } else {
            this.addView((View)this.graphLayout);
        }
        this.addView((View)this.textLayout);
        this.setGravity(17);
        if (context.getResources().getConfiguration().orientation == 1) {
            imgParams = new LinearLayout.LayoutParams(ImageHandler.pixelsToDip(context, 320), ImageHandler.pixelsToDip(context, 227));
            imgParams.gravity = 17;
        } else {
            imgParams = new LinearLayout.LayoutParams(ImageHandler.pixelsToDip(context, 235), ImageHandler.pixelsToDip(context, 227));
            imgParams.gravity = 17;
        }
        if (this.imgGraphic != null) {
            this.imgGraphic.setLayoutParams((ViewGroup.LayoutParams)imgParams);
        }
        this.setTag(TAG_ROOT_LAYOUT);
    }

    private class ActionButtonListener
    implements View.OnClickListener {
        private PushData.Action action;

        public ActionButtonListener(PushData.Action action) {
            this.action = action;
        }

        public void onClick(View view) {
            SLog.d(TAG, "IAM Action: %s %s %s", this.action.label, this.action.link, this.action.event);
            if (LargeIAMRootView.this.inAppActionListener != null) {
                LargeIAMRootView.this.inAppActionListener.onInAppMessageAction(LargeIAMRootView.this, this.action.event, this.action.link);
            }
        }
    }
}

