/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.domain;

import android.content.Context;
import android.content.Intent;
import com.google.android.gms.common.GoogleApiAvailability;
import com.sas.mkt.mobile.sdk.SASCollectorIntentService;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.util.List;

public class AppEnvironment {
    public static final String TAG = AppEnvironment.class.getSimpleName();
    private boolean internetPermissions = false;
    private boolean locationPermissions = false;
    private boolean playServices = false;
    private boolean sdkIntentService = false;
    private boolean jetpackFragments = false;
    private boolean gsonAvailable = false;

    public boolean hasInternetPermissions() {
        return this.internetPermissions;
    }

    public boolean hasPlayServices() {
        return this.playServices;
    }

    public boolean hasSDKIntentService() {
        return this.sdkIntentService;
    }

    public boolean hasJetpackFragments() {
        return this.jetpackFragments;
    }

    public boolean hasGSONAvailable() {
        return this.gsonAvailable;
    }

    private AppEnvironment() {
    }

    public static AppEnvironment initialize(Context context) {
        AppEnvironment ae = new AppEnvironment();
        ae.internetPermissions = context.checkCallingOrSelfPermission("android.permission.INTERNET") == 0;
        Intent intent = new Intent(context, SASCollectorIntentService.class);
        List resolveInfo = context.getPackageManager().queryIntentServices(intent, 0);
        ae.sdkIntentService = resolveInfo != null && resolveInfo.size() > 0;
        try {
            Class.forName("com.google.android.gms.common.GoogleApiAvailability");
            Class.forName("com.google.android.gms.location.LocationServices");
            Class.forName("com.google.android.gms.location.GeofencingClient");
            ae.playServices = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(context) == 0;
        }
        catch (ClassNotFoundException e) {
            SLog.d(TAG, "Play Services not available due to ClassNotFoundException: " + e.getLocalizedMessage(), new Object[0]);
        }
        SLog.d(TAG, "AppEnvironment initialized.  Internet=%s Location=%s PlayServices=%s SDKIntentService=%s", ae.internetPermissions, ae.locationPermissions, ae.playServices, ae.sdkIntentService);
        try {
            Class.forName("androidx.fragment.app.FragmentActivity");
            ae.jetpackFragments = true;
        }
        catch (ClassNotFoundException e) {
            SLog.d(TAG, "Jetpack fragments not available.", new Object[0]);
            ae.jetpackFragments = false;
        }
        try {
            Class.forName("com.google.gson.GsonBuilder");
            ae.gsonAvailable = true;
        }
        catch (ClassNotFoundException e) {
            SLog.d(TAG, "GsonBuilder class not available.", new Object[0]);
        }
        return ae;
    }
}

