/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import com.google.gson.JsonSyntaxException;
import com.sas.mkt.mobile.sdk.JsonHandler;
import com.sas.mkt.mobile.sdk.database.EventsSQLiteHelper;
import com.sas.mkt.mobile.sdk.domain.MobileEvent;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class EventsDataSource {
    private static final String TAG = EventsDataSource.class.getSimpleName();
    private SQLiteDatabase database;
    private static EventsSQLiteHelper dbHelper;
    private final String[] allColumns = new String[]{"_datetime", "_objectJSON"};
    private AtomicInteger dbOpenCounter = new AtomicInteger();
    private final JsonHandler jsonParser = new JsonHandler();
    private static EventsDataSource instance;

    public static EventsDataSource getInstance() {
        if (instance == null) {
            SLog.w(TAG, "EventsDataSource is not initialized.", new Object[0]);
        }
        return instance;
    }

    private EventsDataSource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized EventsDataSource initialize(Context context) {
        if (instance != null) {
            EventsDataSource eventsDataSource = instance;
            synchronized (eventsDataSource) {
                if (dbHelper != null) {
                    dbHelper.close();
                }
            }
        }
        instance = new EventsDataSource();
        dbHelper = new EventsSQLiteHelper(context);
        return instance;
    }

    public synchronized void open() throws SQLException {
        if (this.dbOpenCounter.get() == 0) {
            this.database = dbHelper.getWritableDatabase();
        }
        this.dbOpenCounter.incrementAndGet();
        SLog.d(TAG, "Events data source is open with " + this.dbOpenCounter.get() + " connections.", new Object[0]);
    }

    public synchronized void close() {
        if (this.dbOpenCounter.get() == 1) {
            dbHelper.close();
            SLog.d(TAG, "Events data source is closed.", new Object[0]);
        }
        if (this.dbOpenCounter.get() > 0) {
            this.dbOpenCounter.decrementAndGet();
        }
    }

    public long addEvent(MobileEvent event) {
        if (event == null || event.getEventDateTime() == null) {
            return -1L;
        }
        ContentValues values = new ContentValues();
        values.put("_datetime", Long.valueOf(event.getEventDateTime().getTime()));
        values.put("_objectJSON", this.jsonParser.toJson(event));
        long insertId = this.database.insert("_events", null, values);
        return insertId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvents(List<MobileEvent> events) {
        try {
            this.database.beginTransaction();
            for (MobileEvent event : events) {
                this.addEvent(event);
            }
            this.database.setTransactionSuccessful();
            SLog.d(TAG, "Added %d events.", events.size());
        }
        catch (SQLException e) {
            SLog.e(TAG, (CharSequence)("Error during bulk insert: " + e.getLocalizedMessage()), new Object[0]);
        }
        finally {
            this.database.endTransaction();
        }
    }

    public void deleteOlderEvents(Date date) {
        this.database.delete("_events", "_datetime <= " + date.getTime(), null);
        SLog.d(TAG, "Events deleted earlier than date/time: " + date.toString(), new Object[0]);
    }

    public void deleteAll() {
        this.database.delete("_events", null, null);
        SLog.d(TAG, "All events are deleted.", new Object[0]);
    }

    public List<MobileEvent> getRecentEvents() {
        long now = System.currentTimeMillis();
        long maxAge = now - 432000000L;
        Cursor cursor = this.database.query("_events", this.allColumns, "_datetime >= " + maxAge, null, null, null, "_datetime DESC", "100");
        List<MobileEvent> evts = this.cursorToEvents(cursor);
        SLog.d(TAG, "Retrieved %d recent events.", evts.size());
        cursor.close();
        return evts;
    }

    public List<MobileEvent> getAllEvents() {
        Cursor cursor = this.database.query("_events", this.allColumns, null, null, null, null, null, null);
        List<MobileEvent> evts = this.cursorToEvents(cursor);
        cursor.close();
        SLog.d(TAG, "Retrieved %d total events.", evts.size());
        return evts;
    }

    private List<MobileEvent> cursorToEvents(Cursor cursor) {
        ArrayList<MobileEvent> events = new ArrayList<MobileEvent>();
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            try {
                MobileEvent event = this.cursorToEvent(cursor);
                events.add(event);
            }
            catch (JsonSyntaxException e) {
                SLog.e(TAG, (CharSequence)("Error parsing event from DB: " + e.getLocalizedMessage()), new Object[0]);
            }
            cursor.moveToNext();
        }
        return events;
    }

    private MobileEvent cursorToEvent(Cursor cursor) throws JsonSyntaxException {
        String eventJson = cursor.getString(cursor.getColumnIndex("_objectJSON"));
        MobileEvent event = (MobileEvent)this.jsonParser.fromJson(eventJson, (Type)((Object)MobileEvent.class));
        return event;
    }
}

