/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.beacon;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.os.SystemClock;
import com.sas.mkt.mobile.sdk.InternalSingleton;
import com.sas.mkt.mobile.sdk.beacon.Beacon;
import com.sas.mkt.mobile.sdk.beacon.BeaconParser;
import com.sas.mkt.mobile.sdk.beacon.BeaconScanListener;
import com.sas.mkt.mobile.sdk.domain.SimpleBeacon;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class BeaconScan
implements Runnable {
    private final String TAG = BeaconScan.class.getSimpleName();
    private static final byte MASK_ENABLE = 1;
    private final int SCAN_TIME_MS = InternalSingleton.get().getIntegerConfigurationOption("beacon.scan.time.ms", 10000);
    private final long BEACON_TIMEOUT = (long)InternalSingleton.get().getIntegerConfigurationOption("beacon.timeout.minutes", 2).intValue() * 60000L;
    protected Set<Beacon> beacons;
    protected String fenceId;
    private Map<Beacon, AtomicLong> beaconMap;
    private Set<String> listenFor;
    private BeaconScanListener listener;
    private BeaconParser beaconParser = new BeaconParser();
    private BluetoothLeScanner bluetoothLeScanner;
    private List<ScanFilter> filters = new ArrayList<ScanFilter>();
    private ScanSettings scanSettings;
    private ScanCallback callback = new ScanCallback(){

        public void onScanResult(int callbackType, ScanResult result) {
            try {
                BeaconScan.this.processScanResult(result);
            }
            catch (Exception e) {
                SLog.e(BeaconScan.this.TAG, (CharSequence)("Error processing scan result: " + e.getMessage()), new Object[0]);
            }
        }

        public void onBatchScanResults(List<ScanResult> results) {
            try {
                for (ScanResult result : results) {
                    BeaconScan.this.processScanResult(result);
                }
            }
            catch (Exception e) {
                SLog.e(BeaconScan.this.TAG, (CharSequence)("Error processing scan result: " + e.getMessage()), new Object[0]);
            }
        }

        public void onScanFailed(int errorCode) {
            SLog.e(BeaconScan.this.TAG, (CharSequence)("BTLE Scan failed: " + errorCode), new Object[0]);
        }
    };

    public BeaconScan(List<SimpleBeacon> listenFor, String fenceId, BeaconScanListener listener) {
        SLog.d(this.TAG, "BeaconScan created for " + listenFor.size() + " beacons.", new Object[0]);
        this.fenceId = fenceId;
        this.listener = listener;
        this.listenFor = new HashSet<String>();
        for (SimpleBeacon beacon : listenFor) {
            this.listenFor.add(beacon.getBeaconUUID().toUpperCase());
        }
        ByteBuffer mfgData = ByteBuffer.allocate(23);
        mfgData.putShort((short)533);
        ByteBuffer mfgDataMask = ByteBuffer.allocate(23);
        mfgDataMask.put(0, (byte)1);
        mfgDataMask.put(1, (byte)1);
        ScanFilter filter = new ScanFilter.Builder().setManufacturerData(76, mfgData.array(), mfgDataMask.array()).build();
        this.filters.add(filter);
        this.scanSettings = new ScanSettings.Builder().build();
        this.beaconMap = new HashMap<Beacon, AtomicLong>();
        this.beacons = new HashSet<Beacon>();
    }

    @Override
    public void run() {
        try {
            if (!this.startScan()) {
                SLog.e(this.TAG, (CharSequence)"Failed to start LE scan.", new Object[0]);
            } else {
                SLog.d(this.TAG, "Scanning for LE bluetooth devices...", new Object[0]);
            }
            SystemClock.sleep((long)this.SCAN_TIME_MS);
            this.stopScan();
            long time = System.currentTimeMillis();
            Iterator<Map.Entry<Beacon, AtomicLong>> iter = this.beaconMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Beacon, AtomicLong> entry = iter.next();
                long delta = time - entry.getValue().get();
                if (delta <= this.BEACON_TIMEOUT) continue;
                SLog.d(this.TAG, "Timing out beacon " + entry.getKey(), new Object[0]);
                iter.remove();
            }
        }
        catch (SecurityException e) {
            SLog.e(this.TAG, (CharSequence)("Unable to scan for beacons: " + e.getMessage()), new Object[0]);
        }
        catch (Exception e) {
            SLog.e(e, this.TAG, "Unexpected error is BTLE scan: " + e.getMessage(), new Object[0]);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    protected boolean startScan() {
        this.getScanner().startScan(this.filters, this.scanSettings, this.callback);
        return true;
    }

    @SuppressLint(value={"MissingPermission"})
    protected boolean stopScan() {
        this.getScanner().stopScan(this.callback);
        return true;
    }

    private BluetoothLeScanner getScanner() {
        BluetoothAdapter bluetoothAdapter;
        BluetoothManager bluetoothManager;
        if (this.bluetoothLeScanner == null && (bluetoothManager = (BluetoothManager)InternalSingleton.get().getApplication().getSystemService("bluetooth")) != null && (bluetoothAdapter = bluetoothManager.getAdapter()) != null) {
            this.bluetoothLeScanner = bluetoothAdapter.getBluetoothLeScanner();
        }
        return this.bluetoothLeScanner;
    }

    private void processScanResult(ScanResult result) {
        ScanRecord record = result.getScanRecord();
        if (record != null) {
            Beacon beacon;
            SLog.d(this.TAG, "Detected " + record.getDeviceName() + " " + record.getAdvertiseFlags(), new Object[0]);
            byte[] mfgData = record.getManufacturerSpecificData(76);
            if (mfgData != null && (beacon = this.beaconParser.parse(mfgData)) != null) {
                SLog.d(this.TAG, "Found beacon: " + beacon.getUUID() + " " + beacon.getMajor() + " " + beacon.getMinor() + " " + beacon.getRange(), new Object[0]);
                long time = System.currentTimeMillis();
                if (this.listenFor.contains(beacon.getUUID())) {
                    AtomicLong lastSeen = this.beaconMap.get(beacon);
                    if (lastSeen == null) {
                        SLog.d(this.TAG, "Notifying new beacon in range.", new Object[0]);
                        this.beaconMap.put(beacon, new AtomicLong(time));
                        this.listener.newBeaconInRange(this.fenceId, beacon);
                    } else {
                        SLog.d(this.TAG, "Disregarding beacon already in range.", new Object[0]);
                        lastSeen.set(time);
                    }
                }
                this.beacons.add(beacon);
            }
        }
    }
}

