/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.beacon;

import com.sas.mkt.mobile.sdk.beacon.Beacon;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.nio.ByteBuffer;
import java.util.UUID;

public class BeaconParser {
    public static final short COMPANY_ID_APPLE = 76;
    public static final short BEACON_INDICATOR = 533;
    private final String TAG = BeaconParser.class.getSimpleName();

    public Beacon parse(byte[] data) {
        if (data == null || data.length < 2) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        short indicator = byteBuffer.getShort(0);
        if (533 == indicator) {
            if (data.length == 23) {
                long uuid1 = byteBuffer.getLong(2);
                long uuid2 = byteBuffer.getLong(10);
                UUID uuid = new UUID(uuid1, uuid2);
                short major = byteBuffer.getShort(18);
                short minor = byteBuffer.getShort(20);
                byte range = byteBuffer.get(22);
                return new Beacon(uuid.toString().toUpperCase(), major, minor, Float.valueOf(range));
            }
            SLog.d(this.TAG, "Unexpected beacon data length: " + data.length, new Object[0]);
        } else {
            SLog.w(this.TAG, "BTLE data is non-beacon", new Object[0]);
        }
        return null;
    }
}

