/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.ads;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Rect;
import android.os.Build;
import android.util.Base64;
import com.sas.ia.android.sdk.AbstractAd;
import com.sas.ia.android.sdk.AdDelegate;
import com.sas.ia.android.sdk.AdRequest;
import com.sas.ia.android.sdk.InterstitialAd;
import com.sas.ia.android.sdk.InterstitialWebActivity;
import com.sas.ia.android.sdk.TagProcessResult;
import com.sas.mkt.mobile.sdk.InternalSingleton;
import com.sas.mkt.mobile.sdk.SASCollector;
import com.sas.mkt.mobile.sdk.ads.DataTagParser;
import com.sas.mkt.mobile.sdk.server.MidtierServicesException;
import com.sas.mkt.mobile.sdk.tasks.AdRequestRedirectTask;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SASCollectorInterstitialAd
extends InterstitialAd
implements AdRequestRedirectTask.ResultHandler {
    private final String TAG = SASCollectorInterstitialAd.class.getSimpleName();
    private static Boolean internalBrowserAvailable = null;
    private boolean isAdVisible = true;
    private boolean isAdWindowVisible = true;
    private String spotId = null;
    private String creativeId = null;
    private String taskId = null;
    private String recGroup = null;
    private Map<String, String> tags = null;
    private AdDelegate interceptDelegate = null;
    private AdDelegate userDelegate = null;
    private boolean loadFailed = false;

    public SASCollectorInterstitialAd(Context context) {
        super(context);
        if (Build.VERSION.SDK_INT < 23) {
            SLog.e(this.TAG, (CharSequence)("Mobile spots not supported on Android OS Version: " + Build.VERSION.SDK_INT), new Object[0]);
            return;
        }
        this.setupInterceptDelegate(context);
    }

    private void setupInterceptDelegate(Context context) {
        if (internalBrowserAvailable == null) {
            try {
                ComponentName cn = new ComponentName(context, InterstitialWebActivity.class);
                context.getPackageManager().getActivityInfo(cn, 0);
                internalBrowserAvailable = true;
            }
            catch (PackageManager.NameNotFoundException e) {
                SLog.i(this.TAG, InterstitialWebActivity.class.getSimpleName() + " activity is not registered, defaulting to external browser for click through.", new Object[0]);
                internalBrowserAvailable = false;
            }
        }
        this.setActionInBrowser(internalBrowserAvailable == false);
        this.interceptDelegate = new AdDelegate(){

            @Override
            public void onLoaded(AbstractAd ad) {
                SASCollectorInterstitialAd.this.sendSpotEvent("spot_change", SASCollectorInterstitialAd.this.getEventAttributes());
                SASCollectorInterstitialAd.this.sendSpotEvent("spot_viewable", SASCollectorInterstitialAd.this.getEventAttributes());
                if (SASCollectorInterstitialAd.this.userDelegate != null) {
                    SASCollectorInterstitialAd.this.userDelegate.onLoaded(ad);
                }
                super.onLoaded(ad);
            }

            @Override
            public void onDefaultLoaded(AbstractAd ad) {
                SASCollectorInterstitialAd.this.sendSpotEvent("spot_default_delivered", SASCollectorInterstitialAd.this.getEventAttributes());
                if (SASCollectorInterstitialAd.this.userDelegate != null) {
                    SASCollectorInterstitialAd.this.userDelegate.onDefaultLoaded(ad);
                }
                super.onDefaultLoaded(ad);
            }

            @Override
            public void onLoadFailed(AbstractAd ad, int errorCode, String description, String failingUrl) {
                SASCollectorInterstitialAd.this.loadFailed = true;
                Map eventAttributes = SASCollectorInterstitialAd.this.getEventAttributes();
                if (errorCode == 0 && description != null && description.equals("noHtmlContent")) {
                    eventAttributes.put("errorCode", "No HTML content");
                } else if (errorCode == 2 && description != null && description.equals("noExpectedTags")) {
                    eventAttributes.put("errorCode", "no creative_id and/or task_id");
                } else if (errorCode == 3 && description != null && description.equals("contentParseFailure")) {
                    eventAttributes.put("errorCode", "Html contains invalid tags");
                }
                SASCollectorInterstitialAd.this.sendSpotEvent("spot_failed", eventAttributes);
                if (SASCollectorInterstitialAd.this.userDelegate != null) {
                    SASCollectorInterstitialAd.this.userDelegate.onLoadFailed(ad, errorCode, description, failingUrl);
                }
                super.onLoadFailed(ad, errorCode, description, failingUrl);
            }

            @Override
            public boolean willClose(AbstractAd ad) {
                boolean result = super.willClose(ad);
                if (SASCollectorInterstitialAd.this.userDelegate != null && result) {
                    result = SASCollectorInterstitialAd.this.userDelegate.willClose(ad);
                }
                return result;
            }

            @Override
            public void onClosed(AbstractAd ad) {
                SASCollectorInterstitialAd.this.sendSpotEvent("spot_closed", SASCollectorInterstitialAd.this.getEventAttributes());
                if (SASCollectorInterstitialAd.this.userDelegate != null) {
                    SASCollectorInterstitialAd.this.userDelegate.onClosed(ad);
                }
                super.onClosed(ad);
            }

            @Override
            public boolean willBeginAction(AbstractAd ad, String url) {
                if (!SASCollectorInterstitialAd.this.loadFailed) {
                    Map attrs = SASCollectorInterstitialAd.this.getEventAttributes();
                    attrs.put("uri", url);
                    SASCollectorInterstitialAd.this.sendSpotEvent("spot_clicked", attrs);
                }
                boolean result = super.willBeginAction(ad, url);
                if (SASCollectorInterstitialAd.this.userDelegate != null && result) {
                    result = SASCollectorInterstitialAd.this.userDelegate.willBeginAction(ad, url);
                }
                return result;
            }

            @Override
            public void onActionFinished(AbstractAd ad) {
                if (SASCollectorInterstitialAd.this.userDelegate != null) {
                    SASCollectorInterstitialAd.this.userDelegate.onActionFinished(ad);
                }
                super.onActionFinished(ad);
            }

            @Override
            public boolean willExpand(AbstractAd ad, String url) {
                boolean result = super.willExpand(ad, url);
                if (SASCollectorInterstitialAd.this.userDelegate != null && result) {
                    result = SASCollectorInterstitialAd.this.userDelegate.willExpand(ad, url);
                }
                return result;
            }

            @Override
            public void onExpandFinished(AbstractAd ad) {
                if (SASCollectorInterstitialAd.this.userDelegate != null) {
                    SASCollectorInterstitialAd.this.userDelegate.onExpandFinished(ad);
                }
                super.onExpandFinished(ad);
            }

            @Override
            public boolean willResize(AbstractAd ad, Rect size) {
                boolean result = super.willResize(ad, size);
                if (SASCollectorInterstitialAd.this.userDelegate != null && result) {
                    result = SASCollectorInterstitialAd.this.userDelegate.willResize(ad, size);
                }
                return result;
            }

            @Override
            public void onResizeFinished(AbstractAd ad) {
                if (SASCollectorInterstitialAd.this.userDelegate != null) {
                    SASCollectorInterstitialAd.this.userDelegate.onResizeFinished(ad);
                }
                super.onResizeFinished(ad);
            }
        };
        super.setDelegate(this.interceptDelegate);
    }

    @Override
    public void setDelegate(AdDelegate delegate) {
        this.userDelegate = delegate;
    }

    public void load(String spotId, Map<String, String> attributes) {
        SLog.api("SASCollectorInterstitialAd.load", spotId, attributes);
        this.loadFailed = false;
        if (Build.VERSION.SDK_INT < 23) {
            SLog.e(this.TAG, (CharSequence)("Mobile spots not supported on Android OS Version: " + Build.VERSION.SDK_INT), new Object[0]);
            return;
        }
        if (SASCollector.getInstance().isInitialized()) {
            this.spotId = spotId;
            this.tags = attributes;
            this.creativeId = null;
            this.taskId = null;
            this.recGroup = null;
            InternalSingleton.get().getCommonExecutor().execute(new AdRequestRedirectTask(this.spotId, this));
            this.sendSpotEvent("spot_requested", this.getEventAttributes());
        } else {
            SLog.w(this.TAG, "SASCollector is not initialized, unable to load spot.", new Object[0]);
        }
    }

    @Override
    public void handleResult(String result) {
        if (result == null || result.trim().length() == 0) {
            return;
        }
        try {
            if (this.tags != null) {
                for (Map.Entry<String, String> entry : this.tags.entrySet()) {
                    String encoded = Base64.encodeToString((byte[])entry.getValue().getBytes(), (int)3);
                    encoded = encoded.replace('/', '-');
                    encoded = encoded.replace('+', '.');
                    this.tags.put(entry.getKey(), encoded);
                }
            }
            final AdRequest req = new AdRequest(result, this.tags);
            this.getParentActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        SASCollectorInterstitialAd.this.load(req);
                    }
                    catch (Exception e) {
                        SASCollectorInterstitialAd.this.handleError(new MidtierServicesException(e));
                    }
                }
            });
        }
        catch (IOException e) {
            this.handleError(new MidtierServicesException(e));
        }
    }

    @Override
    public void handleError(MidtierServicesException exception) {
        SLog.e(this.TAG, (CharSequence)("Error fetching ad redirect: " + exception.getLocalizedMessage()), exception);
    }

    private void sendSpotEvent(String eventType, Map<String, String> params) {
        SASCollector.getInstance().addAppEvent(eventType, params);
    }

    public boolean isFullyVisible() {
        return this.isAdVisible && this.isAdWindowVisible;
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.isAdWindowVisible = visibility == 0;
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        this.isAdVisible = visibility == 0;
    }

    @Override
    protected TagProcessResult processAdHTML(String htmlContent) {
        if (htmlContent == null || htmlContent.isEmpty()) {
            return TagProcessResult.noHtmlContent;
        }
        DataTagParser parser = new DataTagParser();
        List<DataTagParser.DataTag> dataTags = parser.parse(htmlContent);
        for (DataTagParser.DataTag dataTag : dataTags) {
            String val = dataTag.attributes.get("data-creativeid");
            if (val != null) {
                this.creativeId = val;
            }
            if ((val = dataTag.attributes.get("data-taskid")) != null) {
                this.taskId = val;
            }
            if ((val = dataTag.attributes.get("data-recgroup")) == null) continue;
            this.recGroup = val;
        }
        Map<String, String> eventAttributes = this.getEventAttributes();
        if (this.creativeId == null || this.creativeId.isEmpty() || this.taskId == null || this.taskId.isEmpty()) {
            return TagProcessResult.noExpectedTags;
        }
        this.loadFailed = false;
        return TagProcessResult.success;
    }

    private Map<String, String> getEventAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>(3);
        attributes.put("spot_id", Objects.toString(this.spotId, ""));
        attributes.put("task_id", Objects.toString(this.taskId, ""));
        attributes.put("creative_id", Objects.toString(this.creativeId, ""));
        if (this.recGroup != null && !this.recGroup.isEmpty()) {
            attributes.put("rec_group", this.recGroup);
        }
        return attributes;
    }
}

