/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.ads;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Base64;
import com.sas.ia.android.sdk.AbstractAd;
import com.sas.ia.android.sdk.Ad;
import com.sas.ia.android.sdk.AdDelegate;
import com.sas.ia.android.sdk.AdRequest;
import com.sas.ia.android.sdk.InterstitialWebActivity;
import com.sas.ia.android.sdk.TagProcessResult;
import com.sas.mkt.mobile.sdk.InternalSingleton;
import com.sas.mkt.mobile.sdk.SASCollector;
import com.sas.mkt.mobile.sdk.ads.DataTagParser;
import com.sas.mkt.mobile.sdk.server.MidtierServicesException;
import com.sas.mkt.mobile.sdk.tasks.AdRequestRedirectTask;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SASCollectorAd
extends Ad
implements AdRequestRedirectTask.ResultHandler {
    private final String TAG = SASCollectorAd.class.getSimpleName();
    private static Boolean internalBrowserAvailable = null;
    private boolean isAdVisible = true;
    private boolean isAdWindowVisible = true;
    private String spotId = null;
    private String creativeId = null;
    private String taskId = null;
    private String recGroup = null;
    private Map<String, String> tags = null;
    private AdDelegate interceptDelegate = null;
    private AdDelegate userDelegate = null;
    private boolean loadFailed = false;

    public SASCollectorAd(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setupIADelegate(context);
    }

    public SASCollectorAd(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setupIADelegate(context);
    }

    public SASCollectorAd(Context context) {
        super(context);
        this.setupIADelegate(context);
    }

    private void setupIADelegate(Context ctx) {
        if (Build.VERSION.SDK_INT < 23) {
            SLog.e(this.TAG, (CharSequence)("Mobile spots not supported on Android OS Version: " + Build.VERSION.SDK_INT), new Object[0]);
            return;
        }
        if (internalBrowserAvailable == null) {
            try {
                ComponentName cn = new ComponentName(ctx, InterstitialWebActivity.class);
                ctx.getPackageManager().getActivityInfo(cn, 0);
                internalBrowserAvailable = true;
            }
            catch (PackageManager.NameNotFoundException e) {
                SLog.i(this.TAG, InterstitialWebActivity.class.getSimpleName() + " activity is not registered, defaulting to external browser for click through.", new Object[0]);
                internalBrowserAvailable = false;
            }
        }
        this.setActionInBrowser(internalBrowserAvailable == false);
        this.interceptDelegate = new AdDelegate(){

            @Override
            public void onLoaded(AbstractAd ad) {
                SLog.d(SASCollectorAd.this.TAG, "Ad loaded: " + SASCollectorAd.this.spotId, new Object[0]);
                SASCollectorAd.this.sendSpotEvent("spot_change", SASCollectorAd.this.getEventAttributes());
                SASCollectorAd.this.sendSpotEvent("spot_viewable", SASCollectorAd.this.getEventAttributes());
                if (SASCollectorAd.this.userDelegate != null) {
                    SASCollectorAd.this.userDelegate.onLoaded(ad);
                }
                super.onLoaded(ad);
            }

            @Override
            public void onDefaultLoaded(AbstractAd ad) {
                SLog.d(SASCollectorAd.this.TAG, "Default Ad loaded: " + SASCollectorAd.this.spotId, new Object[0]);
                SASCollectorAd.this.sendSpotEvent("spot_default_delivered", SASCollectorAd.this.getEventAttributes());
                if (SASCollectorAd.this.userDelegate != null) {
                    SASCollectorAd.this.userDelegate.onDefaultLoaded(ad);
                }
                super.onDefaultLoaded(ad);
            }

            @Override
            public void onLoadFailed(AbstractAd ad, int errorCode, String description, String failingUrl) {
                SLog.d(SASCollectorAd.this.TAG, "Ad Load failed: " + SASCollectorAd.this.spotId, new Object[0]);
                SASCollectorAd.this.loadFailed = true;
                Map eventAttributes = SASCollectorAd.this.getEventAttributes();
                if (errorCode == 0 && description != null && description.equals("noHtmlContent")) {
                    eventAttributes.put("errorCode", "No HTML content");
                } else if (errorCode == 2 && description != null && description.equals("noExpectedTags")) {
                    eventAttributes.put("errorCode", "no creative_id and/or task_id");
                } else if (errorCode == 3 && description != null && description.equals("contentParseFailure")) {
                    eventAttributes.put("errorCode", "Html contains invalid tags");
                }
                SASCollectorAd.this.sendSpotEvent("spot_failed", eventAttributes);
                if (SASCollectorAd.this.userDelegate != null) {
                    SASCollectorAd.this.userDelegate.onLoadFailed(ad, errorCode, description, failingUrl);
                }
                super.onLoadFailed(ad, errorCode, description, failingUrl);
            }

            @Override
            public boolean willClose(AbstractAd ad) {
                boolean result = super.willClose(ad);
                if (SASCollectorAd.this.userDelegate != null && result) {
                    result = SASCollectorAd.this.userDelegate.willClose(ad);
                }
                return result;
            }

            @Override
            public void onClosed(AbstractAd ad) {
                if (SASCollectorAd.this.userDelegate != null) {
                    SASCollectorAd.this.userDelegate.onClosed(ad);
                }
                super.onClosed(ad);
            }

            @Override
            public boolean willBeginAction(AbstractAd ad, String url) {
                if (!SASCollectorAd.this.loadFailed) {
                    Map attrs = SASCollectorAd.this.getEventAttributes();
                    attrs.put("uri", url);
                    SASCollectorAd.this.sendSpotEvent("spot_clicked", attrs);
                }
                boolean result = super.willBeginAction(ad, url);
                if (SASCollectorAd.this.userDelegate != null && result) {
                    result = SASCollectorAd.this.userDelegate.willBeginAction(ad, url);
                }
                return result;
            }

            @Override
            public void onActionFinished(AbstractAd ad) {
                if (SASCollectorAd.this.userDelegate != null) {
                    SASCollectorAd.this.userDelegate.onActionFinished(ad);
                }
                super.onActionFinished(ad);
            }

            @Override
            public boolean willExpand(AbstractAd ad, String url) {
                boolean result = super.willExpand(ad, url);
                if (SASCollectorAd.this.userDelegate != null && result) {
                    result = SASCollectorAd.this.userDelegate.willExpand(ad, url);
                }
                return result;
            }

            @Override
            public void onExpandFinished(AbstractAd ad) {
                if (SASCollectorAd.this.userDelegate != null) {
                    SASCollectorAd.this.userDelegate.onExpandFinished(ad);
                }
                super.onExpandFinished(ad);
            }

            @Override
            public boolean willResize(AbstractAd ad, Rect size) {
                boolean result = super.willResize(ad, size);
                if (SASCollectorAd.this.userDelegate != null && result) {
                    result = SASCollectorAd.this.userDelegate.willResize(ad, size);
                }
                return result;
            }

            @Override
            public void onResizeFinished(AbstractAd ad) {
                if (SASCollectorAd.this.userDelegate != null) {
                    SASCollectorAd.this.userDelegate.onResizeFinished(ad);
                }
                super.onResizeFinished(ad);
            }
        };
        super.setDelegate(this.interceptDelegate);
    }

    @Override
    public void setDelegate(AdDelegate delegate) {
        this.userDelegate = delegate;
    }

    public void load(String spotId, Map<String, String> attributes) {
        SLog.api("SASCollectorAd.load", spotId, attributes);
        this.loadFailed = false;
        if (Build.VERSION.SDK_INT < 23) {
            SLog.e(this.TAG, (CharSequence)("Mobile spots not supported on Android OS Version: " + Build.VERSION.SDK_INT), new Object[0]);
            return;
        }
        if (SASCollector.getInstance().isInitialized()) {
            this.spotId = spotId;
            this.tags = attributes;
            this.creativeId = null;
            this.taskId = null;
            this.recGroup = null;
            this.sendSpotEvent("spot_requested", this.getEventAttributes());
            InternalSingleton.get().getCommonExecutor().execute(new AdRequestRedirectTask(this.spotId, this), true);
        } else {
            SLog.w(this.TAG, "SASCollector is not initialized, unable to load spot.", new Object[0]);
        }
    }

    @Override
    public void handleResult(String result) {
        SLog.d(this.TAG, "Loading ad redirect: " + result, new Object[0]);
        if (result == null || result.trim().length() == 0) {
            ((AdDelegate)this.delegate.get()).onLoadFailed(this, 0, "Invalid Ad Redirect.", null);
            return;
        }
        try {
            if (this.tags != null) {
                for (Map.Entry<String, String> entry : this.tags.entrySet()) {
                    String encoded = Base64.encodeToString((byte[])entry.getValue().getBytes(), (int)3);
                    encoded = encoded.replace('/', '-');
                    encoded = encoded.replace('+', '.');
                    this.tags.put(entry.getKey(), encoded);
                }
            }
            final AdRequest req = new AdRequest(result, this.tags);
            this.getParentActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        SASCollectorAd.this.load(req);
                    }
                    catch (Exception e) {
                        SASCollectorAd.this.handleError(new MidtierServicesException(e));
                    }
                }
            });
        }
        catch (IOException e) {
            this.handleError(new MidtierServicesException(e));
        }
    }

    @Override
    public void handleError(MidtierServicesException exception) {
        SLog.e(exception, this.TAG, "Error fetching ad redirect: " + exception.getLocalizedMessage(), new Object[0]);
        Map<String, String> errorAttributes = this.getEventAttributes();
        if (exception.getErrorData().getCode() == 404) {
            ((AdDelegate)this.delegate.get()).onLoadFailed(this, 0, "Spot Not Found", null);
            errorAttributes.put("errorCode", "Spot Not Found");
            this.sendSpotEvent("spot_failed", errorAttributes);
        } else {
            ((AdDelegate)this.delegate.get()).onLoadFailed(this, 0, "Unable to load spot", null);
            errorAttributes.put("errorCode", "Unable to load spot");
            this.sendSpotEvent("spot_failed", errorAttributes);
        }
    }

    private void sendSpotEvent(String eventType, Map<String, String> params) {
        SASCollector.getInstance().addAppEvent(eventType, params);
    }

    public boolean isFullyVisible() {
        return this.isAdVisible && this.isAdWindowVisible;
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.isAdWindowVisible = visibility == 0;
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        this.isAdVisible = visibility == 0;
    }

    @Override
    protected TagProcessResult processAdHTML(String htmlContent) {
        SLog.d(this.TAG, "Processing Ad content: %s", htmlContent);
        if (htmlContent == null || htmlContent.isEmpty()) {
            return TagProcessResult.noHtmlContent;
        }
        DataTagParser parser = new DataTagParser();
        List<DataTagParser.DataTag> dataTags = parser.parse(htmlContent);
        for (DataTagParser.DataTag dataTag : dataTags) {
            for (Map.Entry<String, String> entry : dataTag.attributes.entrySet()) {
                SLog.d(this.TAG, "Data tag attribute: " + entry.getKey() + "=" + entry.getValue(), new Object[0]);
            }
            String val = dataTag.attributes.get("data-creativeid");
            if (val != null) {
                this.creativeId = val;
            }
            if ((val = dataTag.attributes.get("data-taskid")) != null) {
                this.taskId = val;
            }
            if ((val = dataTag.attributes.get("data-recgroup")) == null) continue;
            this.recGroup = val;
        }
        Map<String, String> eventAttributes = this.getEventAttributes();
        if (this.creativeId == null || this.creativeId.isEmpty() || this.taskId == null || this.taskId.isEmpty()) {
            return TagProcessResult.noExpectedTags;
        }
        this.loadFailed = false;
        return TagProcessResult.success;
    }

    private Map<String, String> getEventAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>(3);
        attributes.put("spot_id", Objects.toString(this.spotId, ""));
        attributes.put("task_id", Objects.toString(this.taskId, ""));
        attributes.put("creative_id", Objects.toString(this.creativeId, ""));
        if (this.recGroup != null && !this.recGroup.isEmpty()) {
            attributes.put("rec_group", this.recGroup);
        }
        return attributes;
    }
}

