/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk.ads;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataTagParser {
    private static final String TAG = DataTagParser.class.getSimpleName();
    private final Pattern DATA_TAG_PATTERN = Pattern.compile("<data ([^>]+)>");
    private final Pattern ATTRIBUTE_PATTERN = Pattern.compile("data-([^=]+)=\"\\S+\"");

    public List<DataTag> parse(String data) {
        ArrayList<DataTag> tags = new ArrayList<DataTag>();
        Matcher matcher = this.DATA_TAG_PATTERN.matcher(data);
        while (matcher.find()) {
            DataTag dt = new DataTag();
            dt.attributes = new HashMap<String, String>();
            tags.add(dt);
            Matcher attrMatcher = this.ATTRIBUTE_PATTERN.matcher(matcher.group());
            while (attrMatcher.find()) {
                String[] tokens = attrMatcher.group().split("=");
                if (tokens == null || tokens.length != 2) continue;
                dt.attributes.put(tokens[0], this.trimQuotes(tokens[1]));
            }
        }
        return tags;
    }

    private String trimQuotes(String str) {
        if (str == null) {
            return str;
        }
        if (str.length() < 2) {
            return str;
        }
        return str.indexOf(34) == 0 && str.lastIndexOf(34) == str.length() - 1 ? str.substring(1, str.length() - 1) : str;
    }

    class DataTag {
        Map<String, String> attributes;

        DataTag() {
        }
    }
}

