/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.location.Location;
import com.google.android.gms.location.LocationResult;
import com.sas.mkt.mobile.sdk.InternalSingleton;
import com.sas.mkt.mobile.sdk.JsonHandler;
import com.sas.mkt.mobile.sdk.SASCollector;
import com.sas.mkt.mobile.sdk.domain.PushData;
import com.sas.mkt.mobile.sdk.iam.SASMobileMessagingDelegate2;
import com.sas.mkt.mobile.sdk.tasks.LoadGeofencesTask;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.lang.reflect.Type;
import java.util.HashMap;

public class SASCollectorIntentService
extends IntentService {
    public static final String TAG = SASCollectorIntentService.class.getSimpleName();
    public static final String ACTION_GEOFENCE_TRANSITION = SASCollectorIntentService.class.getName() + ".geofenceTransition";
    public static final String ACTION_LOCATION_UPDATE = SASCollectorIntentService.class.getName() + ".locationUpdate";
    public static final String ACTION_NEW_PUSH_MESSAGE = SASCollectorIntentService.class.getSimpleName() + ".newPushMessage";
    public static final String ACTION_NOTIFICATION_OPENED = SASCollectorIntentService.class.getSimpleName() + ".notificationOpened";
    public static final String EXTRA_DEVICE_ID = SASCollectorIntentService.class.getSimpleName() + ".deviceID";
    public static final String EXTRA_PUSH_DATA = SASCollectorIntentService.class.getSimpleName() + ".pushData";
    public static final String EXTRA_PUSH_TOKEN = SASCollectorIntentService.class.getSimpleName() + ".pushToken";
    public static final String EXTRA_NOTIFICATION_ID = SASCollectorIntentService.class.getSimpleName() + "notificationId";
    public static final String EXTRA_NOTIFICATION_TASK_ID = SASCollectorIntentService.class.getSimpleName() + "notificationTaskId";
    public static final String EXTRA_NOTIFICATION_CREATIVE_ID = SASCollectorIntentService.class.getSimpleName() + "notificationCreativeId";
    public static final String EXTRA_NOTIFICATION_EVENT_ID = SASCollectorIntentService.class.getSimpleName() + "notificationEventId";
    public static final String EXTRA_NOTIFICATION_SPOT_ID = SASCollectorIntentService.class.getSimpleName() + "notificationSpotId";
    public static final String EXTRA_NOTIFICATION_ACTION_EVENT_ID = SASCollectorIntentService.class.getSimpleName() + "notificationActionEventId";
    public static final String EXTRA_NOTIFICATION_ACTION_LINK = SASCollectorIntentService.class.getSimpleName() + "notificationActionLink";
    private SharedPreferences sharedPreferences = null;

    public SASCollectorIntentService() {
        super(SASCollectorIntentService.class.getSimpleName());
    }

    protected void onHandleIntent(Intent intent) {
        String action;
        if (intent == null) {
            SLog.w(TAG, "Discarding null intent", new Object[0]);
            return;
        }
        SLog.d(TAG, "Handling action: " + intent.getAction(), new Object[0]);
        if (this.sharedPreferences == null) {
            this.sharedPreferences = this.getSharedPreferences("com.sas.mkt.mobile.sdk.SASCollector", 0);
        }
        if (ACTION_GEOFENCE_TRANSITION.equals(action = intent.getAction())) {
            SLog.e(TAG, (CharSequence)"Unexpected geofence intent action.", new Object[0]);
        } else if (ACTION_NEW_PUSH_MESSAGE.equals(action)) {
            String pushDataJSON = intent.getStringExtra(EXTRA_PUSH_DATA);
            this.handleNewPushMessage(pushDataJSON);
        } else if (ACTION_LOCATION_UPDATE.equals(action)) {
            this.handleLocationUpdate(intent);
        } else if (ACTION_NOTIFICATION_OPENED.equals(action)) {
            String link = intent.getStringExtra(EXTRA_NOTIFICATION_ACTION_LINK);
            String actionEvent = intent.getStringExtra(EXTRA_NOTIFICATION_ACTION_EVENT_ID);
            String creativeId = intent.getStringExtra(EXTRA_NOTIFICATION_CREATIVE_ID);
            String taskId = intent.getStringExtra(EXTRA_NOTIFICATION_TASK_ID);
            String spotId = intent.getStringExtra(EXTRA_NOTIFICATION_SPOT_ID);
            this.handleNotificationOpened(actionEvent, creativeId, taskId, spotId, link);
        }
    }

    private void handleNewPushMessage(String pushDataJSON) {
        SLog.d(TAG, "Push data: " + pushDataJSON, new Object[0]);
        JsonHandler json = new JsonHandler();
        PushData pd = (PushData)json.fromJson(pushDataJSON, (Type)((Object)PushData.class));
        if (pd == null) {
            SLog.w(TAG, "Failed to parse PushData from mobile message.", new Object[0]);
        }
        if (pd.template == null) {
            SLog.e(TAG, (CharSequence)"No template specified on message.", new Object[0]);
            return;
        }
        SLog.d(TAG, "Processing mobile message with template " + pd.template, new Object[0]);
        String spotId = String.format("%s_%s", SASCollector.getInstance().getApplicationID(), pd.template);
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (pd.creativeId != null) {
            attrs.put("creative_id", pd.creativeId);
        }
        if (pd.taskId != null) {
            attrs.put("task_id", pd.taskId);
        }
        attrs.put("spot_id", spotId);
        InternalSingleton.get().addAppEventInternal("spot_change", attrs);
        if ("creative.mobileInAppMessage.large".equals(pd.template) || "creative.mobileInAppMessage.small".equals(pd.template)) {
            InternalSingleton.get().getMobileMessageHelper().handleInAppMessage((Context)this, pd, pushDataJSON);
        } else if ("creative.pushNotification".equalsIgnoreCase(pd.template)) {
            InternalSingleton.get().getMobileMessageHelper().handlePushNotification((Context)this, pd, attrs);
        } else {
            SLog.w(TAG, "Unrecognized message template %s", pd.template);
        }
    }

    private void handleNotificationOpened(String actionEvent, String creativeId, String taskId, String spotId, String link) {
        if (actionEvent != null) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            if (creativeId != null) {
                attrs.put("creative_id", creativeId);
            }
            if (taskId != null) {
                attrs.put("task_id", taskId);
            }
            if (spotId != null) {
                attrs.put("spot_id", spotId);
            }
            if (link != null) {
                attrs.put("uri", link);
            }
            InternalSingleton.get().addAppEventInternal(actionEvent, attrs);
        } else {
            SLog.w(TAG, "No action event specified.", new Object[0]);
        }
        if (link != null && link.trim().length() != 0) {
            if (SASCollector.getInstance().getMobileMessagingDelegate2() != null) {
                SASCollector.getInstance().getMobileMessagingDelegate2().action(link, SASMobileMessagingDelegate2.SASMobileMessageType.PUSH_NOTIFICATION);
            }
        } else {
            Intent launchIntent = this.getPackageManager().getLaunchIntentForPackage(this.getPackageName());
            launchIntent.addFlags(0x400000);
            this.startActivity(launchIntent);
        }
    }

    private void handleLocationUpdate(Intent intent) {
        Location loc = (Location)intent.getExtras().getParcelable("location");
        if (loc == null && LocationResult.hasResult((Intent)intent)) {
            LocationResult result = LocationResult.extractResult((Intent)intent);
            loc = result.getLastLocation();
        }
        if (loc != null) {
            SLog.d(TAG, "Location update: " + loc, new Object[0]);
            InternalSingleton.exec(new LoadGeofencesTask((Context)InternalSingleton.get().getApplication(), loc));
        }
    }
}

