/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SASCollectorEvent {
    private String eventKey;
    private Map<String, String> attributes;
    private List<Map<String, String>> cartItems;

    public SASCollectorEvent(String eventKey, Map<String, String> attributes) {
        this.eventKey = eventKey;
        this.attributes = attributes;
        this.cartItems = new ArrayList<Map<String, String>>();
    }

    public SASCollectorEvent(String eventKey) {
        this.eventKey = eventKey;
        this.attributes = null;
        this.cartItems = new ArrayList<Map<String, String>>();
    }

    public SASCollectorEvent() {
        this.eventKey = null;
        this.attributes = null;
        this.cartItems = new ArrayList<Map<String, String>>();
    }

    public void addAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(name, value);
    }

    public String getEventKey() {
        return this.eventKey;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(HashMap<String, String> attributes) {
        this.attributes = new HashMap<String, String>(attributes);
    }

    public List<Map<String, String>> getCartItems() {
        return this.cartItems;
    }

    public int addCartItem(Map<String, String> cartitem) {
        this.cartItems.add(cartitem);
        return this.cartItems.size() - 1;
    }

    public void removeCartItems(int index) {
        if (index < 0 || index >= this.cartItems.size()) {
            return;
        }
        this.cartItems.remove(index);
    }

    public void clearCartItems() {
        this.cartItems.clear();
    }

    public String toString() {
        return String.format("%s %s %s", this.eventKey, this.attributes, this.cartItems);
    }
}

