/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.location.Location;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import com.sas.mkt.mobile.sdk.InternalSingleton;
import com.sas.mkt.mobile.sdk.SASCollector;
import com.sas.mkt.mobile.sdk.SASCollectorEvent;
import com.sas.mkt.mobile.sdk.domain.MobileEvent;
import com.sas.mkt.mobile.sdk.domain.SimpleBeacon;
import com.sas.mkt.mobile.sdk.loc.GeofenceManager;
import com.sas.mkt.mobile.sdk.tasks.LoadGeofencesTask;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.util.HashMap;
import java.util.List;

public class SASCollectorBroadcastReceiver
extends BroadcastReceiver {
    public static final String ACTION_GEOFENCE_TRANSITION = SASCollectorBroadcastReceiver.class.getName() + "_GEOFENCE_TRANSITION";
    private final String TAG = SASCollectorBroadcastReceiver.class.getSimpleName();
    private Context context = null;
    private SharedPreferences sharedPreferences = null;

    public void onReceive(Context ctx, Intent intent) {
        this.context = ctx;
        if ("android.intent.action.BOOT_COMPLETED".equals(intent.getAction())) {
            SLog.d(this.TAG, "Boot Complete detected.", new Object[0]);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    GeofenceManager gm = new GeofenceManager();
                    gm.restoreGeofences(SASCollectorBroadcastReceiver.this.context);
                }
            }).start();
        } else if (ACTION_GEOFENCE_TRANSITION.equals(intent.getAction())) {
            GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent((Intent)intent);
            if (geofencingEvent.hasError()) {
                SLog.e(this.TAG, (CharSequence)("Error in geofencing event: " + geofencingEvent.getErrorCode()), new Object[0]);
                return;
            }
            this.handleGeofenceTransition(ctx, geofencingEvent);
        } else {
            SLog.w(this.TAG, "Unexpected intent action: " + intent.getAction(), new Object[0]);
        }
    }

    private void handleGeofenceTransition(Context context, GeofencingEvent event) {
        if (this.sharedPreferences == null) {
            this.sharedPreferences = context.getSharedPreferences("com.sas.mkt.mobile.sdk.SASCollector", 0);
        }
        InternalSingleton.get().disableBeaconScan();
        int transition = event.getGeofenceTransition();
        List fences = event.getTriggeringGeofences();
        GeofenceManager geofenceManager = new GeofenceManager();
        if (fences != null) {
            for (Geofence fence : fences) {
                SLog.d(this.TAG, "Geofence transition: " + fence.getRequestId() + " " + transition, new Object[0]);
                if (fence.getRequestId().equals("INDEX")) {
                    if (transition != 2) continue;
                    Location loc = event.getTriggeringLocation();
                    InternalSingleton.exec(new LoadGeofencesTask((Context)InternalSingleton.get().getApplication(), loc));
                    continue;
                }
                String eventType = null;
                switch (transition) {
                    case 1: {
                        String current_fence = this.sharedPreferences.getString("current.fence", null);
                        if (current_fence == null || !current_fence.equals(fence.getRequestId())) {
                            this.sharedPreferences.edit().putString("current.fence", fence.getRequestId()).apply();
                            eventType = "enter_geofence";
                        } else {
                            SLog.d(this.TAG, "Ignoring fence transition (%s) already in this fence.", fence.getRequestId());
                        }
                        List<SimpleBeacon> beacons = geofenceManager.getBeaconsForGeofence(context, fence.getRequestId());
                        if (beacons != null && beacons.size() > 0) {
                            ((InternalSingleton)SASCollector.getInstance()).enableBeaconScan(beacons, fence.getRequestId());
                        } else {
                            SLog.d(this.TAG, "No beacons registered for region: " + fence.getRequestId(), new Object[0]);
                        }
                        if (InternalSingleton.get().getGeofenceCallback() == null) break;
                        InternalSingleton.get().getGeofenceCallback().geofenceEntered(fence.getRequestId());
                        break;
                    }
                    case 2: {
                        this.sharedPreferences.edit().remove("current.fence").apply();
                        eventType = "exit_geofence";
                        if (InternalSingleton.get().getGeofenceCallback() == null) break;
                        InternalSingleton.get().getGeofenceCallback().geofenceExited(fence.getRequestId());
                        break;
                    }
                    default: {
                        SLog.d(this.TAG, "Discarding transition.", new Object[0]);
                    }
                }
                if (eventType == null) continue;
                HashMap<String, String> meta = new HashMap<String, String>();
                meta.put("geofence_id", fence.getRequestId());
                InternalSingleton.get().addAppEventInternal(new SASCollectorEvent(eventType, meta), MobileEvent.SessionIndicator.NO_NEW_SESSION);
            }
        }
    }
}

