/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class JsonHandler {
    private GsonBuilder builder = new GsonBuilder();
    private Gson gson = null;

    public JsonHandler() {
        this.builder.registerTypeAdapter(Date.class, (Object)new GmtDateTypeAdapter());
        this.gson = this.builder.create();
    }

    public <T> T fromJson(String json, Type T) {
        return (T)this.gson.fromJson(json, T);
    }

    public <T> T fromJson(Reader reader, Type T) {
        return (T)this.gson.fromJson(reader, T);
    }

    public String toJson(Object obj) {
        return this.gson.toJson(obj);
    }

    public void toJson(Object obj, Writer writer) {
        this.gson.toJson(obj, (Appendable)writer);
    }

    private static class GmtDateTypeAdapter
    implements JsonSerializer<Date>,
    JsonDeserializer<Date> {
        private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);

        private GmtDateTypeAdapter() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized JsonElement serialize(Date date, Type type, JsonSerializationContext jsonSerializationContext) {
            DateFormat dateFormat = this.dateFormat;
            synchronized (dateFormat) {
                String dateFormatAsString = this.dateFormat.format(date);
                return new JsonPrimitive(dateFormatAsString);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Date deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
            try {
                DateFormat dateFormat = this.dateFormat;
                synchronized (dateFormat) {
                    return this.dateFormat.parse(jsonElement.getAsString());
                }
            }
            catch (ParseException e) {
                throw new JsonSyntaxException(jsonElement.getAsString(), (Throwable)e);
            }
        }
    }
}

