/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import com.sas.mkt.mobile.sdk.ActivityLifecycleListener;
import com.sas.mkt.mobile.sdk.DeviceAndApplicationInfoHelper;
import com.sas.mkt.mobile.sdk.JsonHandler;
import com.sas.mkt.mobile.sdk.SASCollector;
import com.sas.mkt.mobile.sdk.SASCollectorEvent;
import com.sas.mkt.mobile.sdk.beacon.Beacon;
import com.sas.mkt.mobile.sdk.beacon.BeaconScan;
import com.sas.mkt.mobile.sdk.beacon.BeaconScanFactory;
import com.sas.mkt.mobile.sdk.beacon.BeaconScanListener;
import com.sas.mkt.mobile.sdk.database.EventsDataSource;
import com.sas.mkt.mobile.sdk.domain.AppEnvironment;
import com.sas.mkt.mobile.sdk.domain.MobileEvent;
import com.sas.mkt.mobile.sdk.domain.PushData;
import com.sas.mkt.mobile.sdk.domain.SessionData;
import com.sas.mkt.mobile.sdk.domain.SimpleBeacon;
import com.sas.mkt.mobile.sdk.iam.MobileMessageHelper;
import com.sas.mkt.mobile.sdk.iam.SASMobileMessagingDelegate2;
import com.sas.mkt.mobile.sdk.id.IDProvider;
import com.sas.mkt.mobile.sdk.id.UUIDProvider;
import com.sas.mkt.mobile.sdk.loc.GeofenceManager;
import com.sas.mkt.mobile.sdk.loc.LocationHelper;
import com.sas.mkt.mobile.sdk.offline.OfflineEventManager;
import com.sas.mkt.mobile.sdk.tasks.BaseSASCollectorTask;
import com.sas.mkt.mobile.sdk.tasks.CleanRemoteImagesTask;
import com.sas.mkt.mobile.sdk.tasks.DetachIdentity;
import com.sas.mkt.mobile.sdk.tasks.IdentityTask;
import com.sas.mkt.mobile.sdk.tasks.QueueEventTask;
import com.sas.mkt.mobile.sdk.tasks.SASCollectorExecutor;
import com.sas.mkt.mobile.sdk.tasks.UpdateToken;
import com.sas.mkt.mobile.sdk.util.SLog;
import com.sas.mkt.mobile.sdk.util.SecureStorage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class InternalSingleton
extends SASCollector
implements BeaconScanListener {
    public static final int RUNTIME_VERSION_MIN = 23;
    private static final String PROPERTY_KEY_APPLICATION_ID = "application.id";
    private static final String PROPERTY_KEY_TENANT_ID = "tenant.id";
    private static final String PROPERTY_KEY_TAG_SERVER = "tag.server";
    private static final String PROPERTY_KEY_APPLICATION_VERSION = "application.version";
    private static final String PROPERTY_KEY_LOCATION_MONITORING_DISABLED = "location.monitoring.disabled";
    public static final String PROPERTY_KEY_GEOFENCE_RESPONSIVENESS = "geofence.responsiveness";
    private Properties config;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private Application application = null;
    private ActivityLifecycleListener activityListener = null;
    private String deviceId = null;
    private IDProvider idProvider = null;
    private SessionData sessionData = null;
    private AppEnvironment appEnvironment = null;
    private SharedPreferences sharedPreferences = null;
    private boolean disableAppRelauchOnNotificationOpen = false;
    private SASMobileMessagingDelegate2 mobileMessagingDelegate2;
    private File remoteFilesDir = null;
    private SASCollector.GeofenceCallback geofenceCallback;
    private SASCollector.EventCallback eventCallback;
    private SASCollectorExecutor executor = new SASCollectorExecutor();
    private static ScheduledFuture<?> beaconScanFuture;
    private MobileMessageHelper mobileMessageHelper;
    private JsonHandler jsonHandler;
    private LocationHelper locationHelper;

    @SuppressLint(value={"ObsoleteSdkInt"})
    public static boolean checkVersion() {
        if (Build.VERSION.SDK_INT < 23) {
            Log.e((String)TAG, (String)("Mobile spots not supported on Android OS Version: " + Build.VERSION.SDK_INT));
            return false;
        }
        return true;
    }

    public static InternalSingleton get() {
        SASCollector sasCollector = SASCollector.getInstance();
        if (sasCollector == null) {
            SLog.e(TAG, (CharSequence)"SASCollector instance not initialized.", new Object[0]);
            return null;
        }
        if (sasCollector instanceof InternalSingleton) {
            return (InternalSingleton)sasCollector;
        }
        SLog.e(TAG, (CharSequence)("Unexpected SASCollector class: " + sasCollector.getClass().getName()), new Object[0]);
        return null;
    }

    public static void exec(BaseSASCollectorTask task) {
        InternalSingleton instance = InternalSingleton.get();
        SASCollectorExecutor executor = instance.getCommonExecutor();
        executor.execute(task);
    }

    InternalSingleton() {
        this.sessionData = new SessionData();
        this.idProvider = new UUIDProvider();
        this.config = new Properties();
    }

    public void setCommonExecutor(SASCollectorExecutor executor) {
        this.executor = executor;
    }

    public SASCollectorExecutor getCommonExecutor() {
        return this.executor;
    }

    protected void setConfigurationOption(String name, String value) {
        this.config.setProperty(name, value);
    }

    public String getConfigurationOption(String name, String defaultValue) {
        return this.config.getProperty(name, defaultValue);
    }

    public Integer getIntegerConfigurationOption(String name, Integer defaultValue) {
        String value = null;
        try {
            value = this.config.getProperty(name, null);
            if (value == null) {
                return defaultValue;
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            SLog.e(TAG, (CharSequence)("Error parsing expected integer in configuration property " + name + " " + value), new Object[0]);
            return defaultValue;
        }
    }

    protected void loadConfigurationOptions(Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            this.config.setProperty(key, properties.getProperty(key).trim());
        }
    }

    public File getRemoteFilesDir() {
        return this.remoteFilesDir;
    }

    @Override
    public void initialize(Context context) {
        SLog.api("initialize", context);
        if (context == null) {
            SLog.e(TAG, (CharSequence)"Context is null, unable to initialize.", new Object[0]);
            return;
        }
        if (!InternalSingleton.checkVersion()) {
            return;
        }
        if (!this.isInitialized()) {
            try {
                SLog.d(TAG, "SASCollector initializing (%s)", context);
                if (context instanceof Activity) {
                    this.application = ((Activity)context).getApplication();
                } else if (context instanceof Application) {
                    this.application = (Application)context;
                } else {
                    SLog.e(TAG, (CharSequence)"Context is neither Application nor Activity, unable to initialize.", new Object[0]);
                    return;
                }
                this.appEnvironment = AppEnvironment.initialize((Context)this.application);
                this.sharedPreferences = this.application.getSharedPreferences("com.sas.mkt.mobile.sdk.SASCollector", 0);
                if (this.sharedPreferences.contains("geofences")) {
                    SLog.w(TAG, "Removing unencrypted geofence data.", new Object[0]);
                    this.sharedPreferences.edit().remove("geofences").apply();
                }
                if (!this.appEnvironment.hasInternetPermissions()) {
                    SLog.e(TAG, (CharSequence)"SASCollector SDK failed to initialized: App does not have internet permissions.", new Object[0]);
                    return;
                }
                if (!this.appEnvironment.hasGSONAvailable()) {
                    SLog.e(TAG, (CharSequence)"GSON Parsing library not available, please include it in your project dependencies.", new Object[0]);
                    return;
                }
                try {
                    InputStream stream = this.getClass().getClassLoader().getResourceAsStream("SASCollector.properties");
                    Properties props = new Properties();
                    if (stream != null) {
                        SLog.i(TAG, "Loading configuration from classpath SASCollector.properties", new Object[0]);
                        props.load(stream);
                    } else {
                        stream = this.application.getAssets().open("SASCollector.properties", 2);
                        SLog.i(TAG, "Loading configuration from assets/SASCollector.properties", new Object[0]);
                        props.load(stream);
                    }
                    SLog.i(TAG, "Properties (" + props.size() + "):", new Object[0]);
                    for (String name : props.stringPropertyNames()) {
                        SLog.i(TAG, name + "=" + props.getProperty(name), new Object[0]);
                    }
                    this.loadConfigurationOptions(props);
                    SecureStorage.getInstance().init(this.getTenantID());
                }
                catch (IOException e) {
                    SLog.e(TAG, (CharSequence)"Unable to load SASCollector.properties configuration file.", e);
                }
                String disableRelaunch = this.getConfigurationOption("apprelaunch.disabled.on.notification.open", "false");
                this.disableAppRelauchOnNotificationOpen = disableRelaunch.equals("true");
                this.deviceId = this.sharedPreferences.getString("device.id", null);
                if (this.deviceId == null) {
                    this.deviceId = this.getConfigurationOption("static.device.id", null);
                    if (this.deviceId == null) {
                        this.deviceId = this.idProvider.generateID();
                        SLog.d(TAG, "Generated new device ID: %s", this.deviceId);
                        this.sharedPreferences.edit().putString("device.id", this.deviceId).apply();
                        this.getSessionData().setFirstSession(true);
                    } else {
                        SLog.i(TAG, "Using static device ID: " + this.deviceId, new Object[0]);
                    }
                } else {
                    SLog.d(TAG, "DeviceID from SharedPreferences: %s", this.deviceId);
                    this.getSessionData().setFirstSession(false);
                }
                int w1 = Integer.parseInt(this.deviceId.substring(0, 2), 16) << 8;
                int w2 = Integer.parseInt(this.deviceId.substring(this.deviceId.length() - 2), 16);
                this.sessionData.setDeviceIdSeed(w1 | w2);
                SLog.d(TAG, "DeviceID seed is %04x", this.sessionData.getDeviceIdSeed());
                EventsDataSource.initialize((Context)this.application);
                new Thread((Runnable)OfflineEventManager.getInstance(), "SASCollector Event Thread").start();
                this.activityListener = new ActivityLifecycleListener((Context)this.application);
                this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityListener);
                this.locationHelper = new LocationHelper();
                this.initialized.set(true);
                SLog.d(TAG, "SASCollector initialized.", new Object[0]);
                if (context instanceof Activity) {
                    Activity activity = (Activity)context;
                    this.activityListener.setCurrentActivity(activity, true);
                }
                File sas_dir = new File(context.getCacheDir(), "sas");
                this.remoteFilesDir = new File(sas_dir, "remote_files");
                this.getCommonExecutor().execute(new CleanRemoteImagesTask());
            }
            catch (Exception e) {
                this.initialized.set(false);
                SLog.e(TAG, (CharSequence)("Error initializing SASCollector: " + e.getClass().getSimpleName() + " " + e.getMessage()), new Object[0]);
            }
        } else {
            SLog.w(TAG, "SASCollector already initialized.", new Object[0]);
        }
        super.initialize(context);
    }

    public MobileMessageHelper getMobileMessageHelper() {
        if (this.mobileMessageHelper == null) {
            this.mobileMessageHelper = new MobileMessageHelper();
        }
        return this.mobileMessageHelper;
    }

    public JsonHandler getJsonHandler() {
        if (this.jsonHandler == null) {
            this.jsonHandler = new JsonHandler();
        }
        return this.jsonHandler;
    }

    @Override
    public String getApplicationID() {
        return this.getConfigurationOption(PROPERTY_KEY_APPLICATION_ID, null);
    }

    @Override
    public void setApplicationID(String value) {
        SLog.api("setApplicationID", value);
        this.setConfigurationOption(PROPERTY_KEY_APPLICATION_ID, value.trim());
    }

    @Override
    public String getApplicationVersion() {
        String version = this.getConfigurationOption(PROPERTY_KEY_APPLICATION_VERSION, null);
        if (version == null) {
            try {
                PackageInfo pInfo = this.application.getPackageManager().getPackageInfo(this.application.getPackageName(), 0);
                int versionCode = pInfo.versionCode;
                return versionCode + "";
            }
            catch (PackageManager.NameNotFoundException ex) {
                return "unknownVersion";
            }
        }
        return version;
    }

    @Override
    public void setApplicationVersion(String version) {
        SLog.api("setApplicationVersion", version);
        this.setConfigurationOption(PROPERTY_KEY_APPLICATION_VERSION, version);
    }

    @Override
    public String getTagServer() {
        return this.getConfigurationOption(PROPERTY_KEY_TAG_SERVER, null);
    }

    @Override
    public void setTagServer(String value) {
        SLog.api("setTagServer", value);
        this.setConfigurationOption(PROPERTY_KEY_TAG_SERVER, value.trim());
    }

    @Override
    public String getTenantID() {
        return this.getConfigurationOption(PROPERTY_KEY_TENANT_ID, null);
    }

    @Override
    public void setTenantID(String value) {
        SLog.api("setTenantID", value);
        SecureStorage.getInstance().init(value);
        this.setConfigurationOption(PROPERTY_KEY_TENANT_ID, value.trim());
    }

    @Override
    public void addAppEvent(String eventName, Map<String, String> data) {
        SLog.api("addAppEvent", eventName, data);
        this.addAppEventInternal(new SASCollectorEvent(eventName, data), MobileEvent.SessionIndicator.NONE);
    }

    public void addAppEventInternal(String eventName, Map<String, String> data) {
        this.addAppEventInternal(Arrays.asList(new SASCollectorEvent(eventName, data)), MobileEvent.SessionIndicator.NONE);
    }

    public void addAppEventInternal(SASCollectorEvent event) {
        this.addAppEventInternal(Arrays.asList(event), MobileEvent.SessionIndicator.NONE);
    }

    public void addAppEventInternal(SASCollectorEvent event, MobileEvent.SessionIndicator sessionIndicator) {
        this.addAppEventInternal(Arrays.asList(event), sessionIndicator);
    }

    public void addAppEventInternal(List<SASCollectorEvent> events, MobileEvent.SessionIndicator sessionIndicator) {
        if (this.isInitialized() && events != null) {
            InternalSingleton.exec(new QueueEventTask(events, sessionIndicator));
        } else {
            SLog.w(TAG, "SASCollector is not initialized, discarding events", new Object[0]);
        }
    }

    @Override
    public void addAppEvent(SASCollectorEvent event) {
        SLog.api("addAppEvent", event);
        this.addAppEventInternal(event, MobileEvent.SessionIndicator.NONE);
    }

    @Override
    public void addAppEvents(List<SASCollectorEvent> events) {
        SLog.api("addAppEvents", events);
        this.addAppEventInternal(events, MobileEvent.SessionIndicator.NONE);
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        SLog.api("onConfigurationChanged", newConfig);
        if (this.isInitialized()) {
            this.activityListener.ignoreActivityReload();
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized.get();
    }

    @Override
    public String getDeviceID() {
        return this.deviceId;
    }

    @Override
    public void resetDeviceID() {
        SLog.api("resetDeviceID", new Object[0]);
        if (this.isInitialized()) {
            SLog.d(TAG, "Resetting Device ID", new Object[0]);
            this.deviceId = this.idProvider.generateID();
            SLog.d(TAG, "Generated new device ID: %s", this.deviceId);
            this.getSessionData().setFirstSession(true);
            this.sharedPreferences.edit().putString("device.id", this.deviceId).apply();
            this.sessionData.clear();
            int w1 = Integer.parseInt(this.deviceId.substring(0, 2), 16) << 8;
            int w2 = Integer.parseInt(this.deviceId.substring(this.deviceId.length() - 2), 16);
            this.sessionData.setDeviceIdSeed(w1 | w2);
            this.sessionData.clearLastIdentity();
        } else {
            SLog.w(TAG, "SASCollector is not initialized, device ID will not be reset.", new Object[0]);
        }
    }

    @Override
    public void identityWithType(String type, String value) {
        SLog.dapi("identityWithType", type, value);
        if (this.getSessionData().identityUnchanged(type, value)) {
            SLog.w(TAG, "Discarding duplicate identity %s %s", type, value);
        } else {
            HashMap<String, String> meta = new HashMap<String, String>();
            meta.put("logon_type", type);
            meta.put("logon_value", value);
            this.getSessionData().setLastIdentity(type, value);
            InternalSingleton.get().addAppEventInternal("identity", meta);
        }
    }

    @Override
    public void newPage(String uri) {
        SLog.api("newPage", uri);
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put("uri", uri);
        try {
            new URI(uri);
            InternalSingleton.get().addAppEventInternal("load", meta);
        }
        catch (URISyntaxException e) {
            SLog.e(TAG, (CharSequence)"Invalid URI (%s) :: %s", uri, e.getMessage());
        }
    }

    public SessionData getSessionData() {
        return this.sessionData;
    }

    public AppEnvironment getAppEnvironment() {
        return this.appEnvironment;
    }

    public Application getApplication() {
        return this.application;
    }

    public Activity getCurrentActivity() {
        if (this.activityListener != null) {
            return this.activityListener.getCurrentActivity();
        }
        return null;
    }

    @Override
    public void registerForMobileMessages(String token) {
        this.registerForMobileMessages(token, null);
    }

    @Override
    public void registerForMobileMessages(String token, SASCollector.TokenRegistrationCallback callback) {
        SLog.api("registerForMobileMessages", token);
        if (!InternalSingleton.checkVersion()) {
            if (callback == null) {
                return;
            }
            callback.onComplete(false);
            return;
        }
        if (!this.isInitialized()) {
            SLog.w(TAG, "SASCollector is not initialized, unable to register for mobile messages.", new Object[0]);
            if (callback == null) {
                return;
            }
            callback.onComplete(false);
            return;
        }
        this.getCommonExecutor().execute(new UpdateToken(token, this.getDeviceID(), this.getApplicationID(), callback));
    }

    @Override
    public void setMobileMessagingIcon(int resourceId) {
        SLog.api("setMobileMessagingIcon", resourceId);
        if (this.isInitialized()) {
            this.sharedPreferences.edit().putInt("mobile.message.icon.resource", resourceId).apply();
        } else {
            SLog.w(TAG, "SASCollector is not initialized, unable to set mobile messaging icon.", new Object[0]);
        }
    }

    @Override
    public void setMobileMessagingIconColor(int color) {
        if (this.isInitialized()) {
            this.sharedPreferences.edit().putInt("mobile.message.icon.color.resource", color).apply();
        } else {
            SLog.w(TAG, "SASCollector is not initialized, unable to set push notification icon color.", new Object[0]);
        }
    }

    @Override
    public void setPushNotificationChannelId(String channelId) {
        SLog.api("setPushNotificationChannelId", channelId);
        if (this.isInitialized()) {
            this.sharedPreferences.edit().putString("push.notification.channel.id", channelId).apply();
        } else {
            SLog.w(TAG, "SASCollector is not initialized, unable to set push notificiation channel.", new Object[0]);
        }
    }

    @Override
    public boolean handleMobileMessage(Bundle bundle) {
        SLog.api("handleMobileMessage", bundle);
        return this.handleMobileMessage(Collections.singletonMap("MobileMessage", bundle.getString("MobileMessage")));
    }

    @Override
    public boolean handleMobileMessage(Map<String, String> data) {
        SLog.api("handleMobileMessage", data);
        if (!InternalSingleton.checkVersion()) {
            return false;
        }
        try {
            if (this.isInitialized()) {
                String pushDataJSON = data.get("MobileMessage");
                if (pushDataJSON != null) {
                    SLog.d(TAG, "Push data: " + pushDataJSON, new Object[0]);
                    JsonHandler json = new JsonHandler();
                    PushData pd = (PushData)json.fromJson(pushDataJSON, (Type)((Object)PushData.class));
                    if (pd == null) {
                        SLog.w(TAG, "Failed to parse PushData from mobile message.", new Object[0]);
                    }
                    if (pd.template == null) {
                        SLog.e(TAG, (CharSequence)"No template specified on message.", new Object[0]);
                        return true;
                    }
                    SLog.d(TAG, "Processing mobile message with template " + pd.template, new Object[0]);
                    String spotId = String.format("%s_%s", SASCollector.getInstance().getApplicationID(), pd.template);
                    HashMap<String, String> attrs = new HashMap<String, String>();
                    if (pd.creativeId != null) {
                        attrs.put("creative_id", pd.creativeId);
                    }
                    if (pd.taskId != null) {
                        attrs.put("task_id", pd.taskId);
                    }
                    attrs.put("spot_id", spotId);
                    if ("creative.mobileInAppMessage.large".equals(pd.template) || "creative.mobileInAppMessage.small".equals(pd.template)) {
                        InternalSingleton.get().addAppEventInternal("spot_change", attrs);
                        InternalSingleton.get().getMobileMessageHelper().handleInAppMessage((Context)this.application, pd, pushDataJSON);
                    } else if ("creative.pushNotification".equalsIgnoreCase(pd.template)) {
                        attrs.put("mobile_platform", DeviceAndApplicationInfoHelper.getDevicePlatform());
                        InternalSingleton.get().addAppEventInternal(new SASCollectorEvent("spot_change", attrs), MobileEvent.SessionIndicator.NO_NEW_SESSION);
                        InternalSingleton.get().getMobileMessageHelper().handlePushNotification((Context)this.application, pd, attrs);
                    } else {
                        SLog.w(TAG, "Unrecognized message template %s", pd.template);
                    }
                    return true;
                }
                SLog.d(TAG, "Unrecognized bundle data for mobile message.", new Object[0]);
                return false;
            }
            SLog.w(TAG, "SASCollector is not initialized, unable to process mobile message.", new Object[0]);
            return false;
        }
        catch (Exception e) {
            SLog.w(TAG, "Unexpected exception processing mobile message: " + e.getClass().getSimpleName() + " " + e.getMessage(), new Object[0]);
            return false;
        }
    }

    @Override
    public void setMobileMessagingDelegate2(SASMobileMessagingDelegate2 delegate) {
        SLog.api("setMobileMessagingDelegate2", delegate);
        this.mobileMessagingDelegate2 = delegate;
    }

    @Override
    public SASMobileMessagingDelegate2 getMobileMessagingDelegate2() {
        return this.mobileMessagingDelegate2;
    }

    @Override
    public void shutdown() {
        SLog.api("shutdown", new Object[0]);
        if (this.isInitialized()) {
            this.initialized.set(false);
            OfflineEventManager.getInstance().stop();
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityListener);
            if (this.appEnvironment != null && this.appEnvironment.hasPlayServices()) {
                this.getCommonExecutor().execute(new BaseSASCollectorTask(){

                    @Override
                    public void run() {
                        try {
                            SLog.d(SASCollector.TAG, "Clearing active geofences...", new Object[0]);
                            new GeofenceManager().clearGeofences((Context)InternalSingleton.this.application);
                            SLog.d(SASCollector.TAG, "Finished clearing active geofences.", new Object[0]);
                        }
                        catch (Exception e) {
                            SLog.w(SASCollector.TAG, "Error clearing geofences: " + e.getMessage(), new Object[0]);
                        }
                    }
                });
            } else {
                Log.d((String)TAG, (String)"Play services not available, geofences will not be cleared.");
            }
            this.getSessionData().clear();
            SLog.d(TAG, "Shutdown.", new Object[0]);
        } else {
            SLog.w(TAG, "SASCollector is not initialized, ignoring request to shutdown.", new Object[0]);
        }
    }

    @Override
    public void startMonitoringLocation() {
        SLog.api("startMonitoringLocation", new Object[0]);
        if (this.isInitialized()) {
            this.sharedPreferences.edit().putBoolean(PROPERTY_KEY_LOCATION_MONITORING_DISABLED, false).apply();
            this.locationHelper.requestLocationUpdate((Context)this.application);
        } else {
            SLog.w(TAG, "SASCollector is not initialized, ignoring request to start location monitoring.", new Object[0]);
        }
    }

    @Override
    public void disableLocationMonitoring() {
        SLog.api("disableLocationMonitoring", new Object[0]);
        if (this.isInitialized()) {
            this.sharedPreferences.edit().putBoolean(PROPERTY_KEY_LOCATION_MONITORING_DISABLED, true).apply();
            this.locationHelper.resetState();
            this.disableBeaconScan();
            new GeofenceManager().clearGeofences((Context)this.getApplication());
        } else {
            SLog.w(TAG, "SASCollector is not initialized, ignoring request to disable location monitoring.", new Object[0]);
        }
    }

    public boolean getLocationMonitoringDisabled() {
        if (this.isInitialized()) {
            return this.sharedPreferences.getBoolean(PROPERTY_KEY_LOCATION_MONITORING_DISABLED, true);
        }
        SLog.w(TAG, "SASCollector is not initialized, unable to determine location monitoring flag", new Object[0]);
        return true;
    }

    public void notifyFocus(Activity activity) {
        if (!this.getLocationMonitoringDisabled() && this.locationHelper != null) {
            this.locationHelper.requestLocationUpdate((Context)activity);
        }
    }

    @Override
    public void detachIdentity(SASCollector.DetachIdentityCallback callback) {
        SLog.api("detachIdentity", callback);
        if (this.isInitialized()) {
            this.getSessionData().clearLastIdentity();
            boolean crossChannel = Boolean.parseBoolean(this.getConfigurationOption("use.cross.channel.detach", Boolean.FALSE.toString()));
            this.getCommonExecutor().execute(new DetachIdentity(this.deviceId, true, callback, crossChannel));
        } else {
            SLog.w(TAG, "SASCollector is not initialized, unable to detach identity.", new Object[0]);
        }
    }

    @Override
    public void shutdownAndDetachIdentity(SASCollector.DetachIdentityCallback callback) {
        SLog.api("shutdownAndDetachIdentity", new Object[0]);
        if (!this.isInitialized()) {
            SLog.w(TAG, "SASCollector is not initialized, ignoring request to shutdown and unable to detach identity.", new Object[0]);
            return;
        }
        this.shutdown();
        this.getSessionData().clearLastIdentity();
        boolean crossChannel = Boolean.parseBoolean(this.getConfigurationOption("use.cross.channel.detach", Boolean.FALSE.toString()));
        this.getCommonExecutor().execute(new DetachIdentity(this.deviceId, false, callback, crossChannel));
    }

    public void enableBeaconScan(List<SimpleBeacon> listenFor, String fenceId) {
        SLog.d(TAG, "enableBeaconScan", new Object[0]);
        if (this.isInitialized()) {
            boolean btEnabled = false;
            try {
                BluetoothManager btMgr = (BluetoothManager)this.application.getSystemService("bluetooth");
                if (btMgr == null) {
                    SLog.e(TAG, (CharSequence)"Unable to get BluetoothManager", new Object[0]);
                    return;
                }
                BluetoothAdapter btAdapter = btMgr.getAdapter();
                if (btAdapter == null) {
                    SLog.e(TAG, (CharSequence)"Unable to get BluetoothAdapter", new Object[0]);
                    return;
                }
                btEnabled = btAdapter.isEnabled();
            }
            catch (SecurityException e) {
                SLog.e(TAG, (CharSequence)("Unable to start beacon scan: " + e.getMessage()), new Object[0]);
            }
            if (btEnabled) {
                if (beaconScanFuture == null) {
                    BeaconScan scan = BeaconScanFactory.newBeaconScan(listenFor, fenceId, this);
                    beaconScanFuture = this.executor.scheduleAtFixedRate(scan, 0L, (long)this.getIntegerConfigurationOption("beacon.frequency.seconds", 20).intValue() * 1000L, TimeUnit.MILLISECONDS);
                } else {
                    SLog.w(TAG, "Ignoring request to enable beacon scan, scan already in progress.", new Object[0]);
                }
            } else {
                SLog.w(TAG, "Ignoring request to enable beacon scan, bluetooth is not enabled.", new Object[0]);
            }
        } else {
            SLog.w(TAG, "Unable to enable beacon scan, SDK is not initialized", new Object[0]);
        }
    }

    public void disableBeaconScan() {
        SLog.d(TAG, "disableBeaconScan", new Object[0]);
        if (beaconScanFuture != null) {
            if (!beaconScanFuture.cancel(false)) {
                SLog.e(TAG, (CharSequence)"Failed to cancel beacon scan.", new Object[0]);
            } else {
                SLog.d(TAG, "Beacon scan canceled", new Object[0]);
            }
            beaconScanFuture = null;
        }
    }

    @Override
    public void newBeaconInRange(String fenceId, Beacon beacon) {
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put("beacon_uuid", beacon.getUUID());
        meta.put("beacon_major", beacon.getMajor().toString());
        meta.put("beacon_minor", beacon.getMinor().toString());
        meta.put("geofence_id", fenceId);
        InternalSingleton.get().addAppEventInternal(new SASCollectorEvent("device_enter_beacon", meta), MobileEvent.SessionIndicator.NO_NEW_SESSION);
        if (this.geofenceCallback != null) {
            this.geofenceCallback.beaconDiscovered(beacon.getUUID(), beacon.getMajor(), beacon.getMinor());
        }
    }

    @Override
    public void identity(String value, String type, SASCollector.IdentityCallback callback) {
        SLog.api("identity", value, type, callback);
        if (this.getSessionData().identityUnchanged(type, value)) {
            SLog.w(TAG, "Discarding duplicate identity %s %s", type, value);
            callback.onComplete(true);
        } else {
            this.getSessionData().setLastIdentity(type, value);
            this.getCommonExecutor().execute(new IdentityTask((Context)this.getApplication(), value, type, this.getDeviceID(), callback), true);
        }
    }

    public SASCollector.EventCallback getEventCallback() {
        return this.eventCallback;
    }

    public SASCollector.GeofenceCallback getGeofenceCallback() {
        return this.geofenceCallback;
    }

    @Override
    public void setGeofenceCallback(SASCollector.GeofenceCallback geofenceCallback) {
        SLog.api("setGeofenceCallback", new Object[0]);
        this.geofenceCallback = geofenceCallback;
    }

    @Override
    public void setEventCallback(SASCollector.EventCallback eventCallback) {
        SLog.api("setEventCallback", new Object[0]);
        this.eventCallback = eventCallback;
    }

    public boolean isAppRelaunchDisabledOnPushOpen() {
        return this.disableAppRelauchOnNotificationOpen;
    }

    public void runOnUiThread(Runnable r) {
        Activity current_activity = this.getCurrentActivity();
        if (current_activity != null && !current_activity.isFinishing() && !current_activity.isDestroyed()) {
            current_activity.runOnUiThread(r);
        } else {
            SLog.w(TAG, "Current Activity is not valid, unable to execute UI update.", new Object[0]);
        }
    }

    @Override
    public String getDecoratedWebSessionURL(String baseURL) {
        String val = this.getSessionBindingParameterValue();
        if (val == null) {
            return null;
        }
        Uri uri = Uri.parse((String)baseURL).buildUpon().appendQueryParameter("_ci_", val).build();
        return uri.toString();
    }

    @Override
    public String getSessionBindingParameter() {
        return String.format("_ci_=%s", this.getSessionBindingParameterValue());
    }

    private String getSessionBindingParameterValue() {
        String deviceId = this.getDeviceID();
        if (deviceId == null) {
            SLog.w(TAG, "No device ID available, unable to create session binding parameter.", new Object[0]);
            return null;
        }
        deviceId = deviceId.replace("-", "");
        SessionData sessionData = this.getSessionData();
        if (sessionData == null) {
            SLog.w(TAG, "No session available, unable to create session binding parameter.", new Object[0]);
            return null;
        }
        String sessionId = sessionData.getCurrentSessionId();
        if (sessionId == null) {
            SLog.w(TAG, "No session ID available, unable to create session binding parameter.", new Object[0]);
            return null;
        }
        return String.format("%s*%s*0*%s", deviceId, sessionId, System.currentTimeMillis());
    }
}

