/*
 * Decompiled with CFR 0.152.
 */
package com.sas.mkt.mobile.sdk;

import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.os.LocaleList;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.sas.mkt.mobile.sdk.InternalSingleton;
import com.sas.mkt.mobile.sdk.SASCollector;
import com.sas.mkt.mobile.sdk.util.SLog;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DeviceAndApplicationInfoHelper {
    private static final String TAG = DeviceAndApplicationInfoHelper.class.getSimpleName();
    private static Map<String, String> cachedDeviceInfo = null;

    public static Map<String, String> buildDeviceInfo(Context context) {
        if (cachedDeviceInfo == null) {
            cachedDeviceInfo = new HashMap<String, String>();
            SLog.i(TAG, "SDK Version: %s", "1.80.3");
            cachedDeviceInfo.put("mobile_sdk_version", "1.80.3");
            cachedDeviceInfo.put("mobile_platform", "Android");
            cachedDeviceInfo.put("mobile_platform_version", Build.VERSION.RELEASE);
            cachedDeviceInfo.put("mobile_device_model", Build.MODEL);
            cachedDeviceInfo.put("mobile_device_mfg", Build.MANUFACTURER);
            if (context != null) {
                TelephonyManager telephony = (TelephonyManager)context.getSystemService("phone");
                if (telephony != null) {
                    String operator;
                    String opName = telephony.getNetworkOperatorName();
                    if (opName != null && opName.length() > 0) {
                        cachedDeviceInfo.put("mobile_carrier_name", telephony.getNetworkOperatorName());
                    }
                    if ((operator = telephony.getNetworkOperator()) != null) {
                        try {
                            String countryCode = operator.substring(0, 3);
                            String netCode = operator.substring(3);
                            if (countryCode != null && countryCode.length() > 0) {
                                cachedDeviceInfo.put("mobile_country_code", countryCode);
                            }
                            if (netCode != null && netCode.length() > 0) {
                                cachedDeviceInfo.put("mobile_network_code", netCode);
                            }
                        }
                        catch (Exception e) {
                            SLog.w(TAG, "Invalid network operator: " + operator, new Object[0]);
                        }
                    }
                }
                WindowManager windowManager = (WindowManager)context.getSystemService("window");
                Display disp = windowManager.getDefaultDisplay();
                Point p = new Point();
                disp.getSize(p);
                DisplayMetrics displayMetrics = new DisplayMetrics();
                disp.getMetrics(displayMetrics);
                float heightInches = (float)displayMetrics.heightPixels / displayMetrics.ydpi;
                float widthInches = (float)displayMetrics.widthPixels / displayMetrics.xdpi;
                double diagonalSize = Math.sqrt(Math.pow(heightInches, 2.0) + Math.pow(widthInches, 2.0));
                cachedDeviceInfo.put("mobile_device_type", diagonalSize >= 6.5 ? "tablet" : "phone");
                cachedDeviceInfo.put("mobile_screen_height", Integer.toString(p.y));
                cachedDeviceInfo.put("mobile_screen_width", Integer.toString(p.x));
            } else {
                SLog.w(TAG, "Context is null, unable to determine carrier or display data.", new Object[0]);
            }
        }
        HashMap<String, String> allMeta = new HashMap<String, String>();
        allMeta.putAll(cachedDeviceInfo);
        if (context != null && context.getResources() != null && context.getResources().getConfiguration() != null) {
            Locale locale = null;
            if (Build.VERSION.SDK_INT >= 24) {
                LocaleList localeList = context.getResources().getConfiguration().getLocales();
                if (localeList != null && localeList.size() > 0) {
                    locale = localeList.get(0);
                }
            } else {
                locale = context.getResources().getConfiguration().locale;
            }
            if (locale != null) {
                String language = DeviceAndApplicationInfoHelper.localeToString(context.getResources().getConfiguration().locale);
                allMeta.put("mobile_app_language", language);
                allMeta.put("mobile_device_language", language);
            } else {
                SLog.w(TAG, "Unable to determine current locale.", new Object[0]);
            }
        } else {
            SLog.w(TAG, "Unable to determine language from available context data.", new Object[0]);
        }
        allMeta.put("mobile_app_version", SASCollector.getInstance().getApplicationVersion());
        if (InternalSingleton.get().getSessionData().isFirstSession()) {
            allMeta.put("visitor_state", "new");
            InternalSingleton.get().getSessionData().setFirstSession(false);
        } else {
            allMeta.put("visitor_state", "returning");
        }
        return allMeta;
    }

    private static String localeToString(Locale locale) {
        if (locale == null) {
            return "";
        }
        return locale.getLanguage().toLowerCase();
    }

    public static String getDevicePlatform() {
        if (cachedDeviceInfo == null) {
            return "Android";
        }
        return cachedDeviceInfo.get("mobile_platform");
    }
}

